(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                           pp_control.ml                                  *)
(****************************************************************************)

type pp_global_defaults =
    {infinity : int ref;
     line_length : int ref;
     line_break : int ref;
     margin : int ref;
     min_space_left : int ref;
     max_indent : int ref;
     max_depth : int ref;
     limit_depth : int ref;
     ellipsis : string ref;
     format_ellipsis : bool ref};;

type 'a pp_formatter_defaults =
    {output : (string -> int -> int -> unit) ref;
     flush_out : (unit -> unit) ref;
     print : ('a -> (int * string stream)) ref};;

let (dflt_gp:pp_global_defaults) =
    {infinity = ref  9999;
     line_length = ref 78;
     line_break = ref 6;
     margin = ref 72;
     min_space_left = ref 10;
     max_indent = ref 62;
     max_depth = ref 35;
     limit_depth = ref 55;
     ellipsis = ref ".";
     format_ellipsis = ref true}
;;

let copy_gp ogp = 
    {infinity = ref (!((ogp.infinity)));
     line_length = ref (!(ogp.line_length));
     line_break = ref (!(ogp.line_break));
     margin = ref (!(ogp.margin));
     min_space_left = ref (!(ogp.min_space_left));
     max_indent = ref (!(ogp.max_indent));
     max_depth = ref (!(ogp.max_depth));
     limit_depth = ref (!(ogp.limit_depth));
     ellipsis = ref (!(ogp.ellipsis));
     format_ellipsis = ref (!(ogp.format_ellipsis))}
;;

let output_substring = output;;

let copy_fp ofp =
    {output = ref (!(ofp.output));
     flush_out = ref (!(ofp.flush_out));
     print = ref (!(ofp.print))}
;;
