(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                               pp.mli                                     *)
(****************************************************************************)
#open "pp_control";;

exception Format of string;;

type pp_global_params;;
type 'a pp_formatter_params;;
type 'a ppcmd_token;;
type 'a ppdir_token;;

type 'a ppcmds == 'a ppcmd_token stream;;
type 'a ppdirs == 'a ppdir_token stream;;


(* formatting COMMANDS *)
value PR : 'a -> 'a ppcmd_token;; (* print_as *)
value BRK : int * int -> 'a ppcmd_token;; (* print_break *)
value FNL : 'a ppcmd_token;; (* flush_newline *)
value PifB : 'a ppcmd_token;; (* print_if_broken *)
value WS : int -> 'a ppcmd_token;; (* print_white_space *)

(* derived directives *)
value SPC : 'a ppcmd_token;; (* print_space *)
value CUT : 'a ppcmd_token;; (* print_cut *)

(* boxing commands *)
value H : int -> 'a ppcmds -> 'a ppcmd_token stream;; (* H box *) 
value V : int -> 'a ppcmds -> 'a ppcmd_token stream;; (* V box *)
value HV : int -> 'a ppcmds -> 'a ppcmd_token stream;; (* HV box *) 
value HOV : int -> 'a ppcmds -> 'a ppcmd_token stream;; (* HOV box *)

(* formatting DIRECTIVES *)
value PNL : 'a ppdir_token;; (* print_newline *)
value FLSH : 'a ppdir_token;; (* print_flush *)
value PPCMDS : 'a ppcmds -> 'a ppdir_token;;

(* formatter constructors *)
value freeze_gp : pp_global_defaults -> pp_global_params;;
value freeze_fp : 'a pp_formatter_defaults -> 'a pp_formatter_params;;

value make_pp : pp_global_params -> 'a pp_formatter_params -> 'a ppdirs -> unit;;
value with_output_to : 'a pp_formatter_defaults -> out_channel -> unit;;

value PPDIR_WITH : pp_global_defaults -> 'a pp_formatter_defaults -> 'a ppdirs -> unit;;

value PP_WITH : pp_global_defaults -> 'a pp_formatter_defaults -> 'a ppcmds -> unit;;
value PPNL_WITH : pp_global_defaults -> 'a pp_formatter_defaults -> 'a ppcmds -> unit;;

value HB : int -> 'a ppcmd_token;; (* open_hbox *)
value VB : int -> 'a ppcmd_token;; (* open_vbox *)
value HVB : int -> 'a ppcmd_token;; (* open_hvbox *)
value HOVB : int -> 'a ppcmd_token;; (* open_hovbox *)
value CLOSE : 'a ppcmd_token;; (* close_box *)
