(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                            funqueue.ml                                   *)
(****************************************************************************)
#open "prelude";;

(* type 'a queue == ('a list * 'a list);; *)

let newq () = ([],[]);;

let enq = fun
    (front,rear) x ->  (front,x::rear);;

let rec deq = function
    ([],[]) -> failwith "deq"
  | (hd::tl,rear) -> (hd,(tl,rear))
  | (_,[hd]) -> (hd,([],[]))
  | (_,hd::tl) -> deq (rev tl, [hd]);;

let rec first_elem = function
    (([],[]) as q) -> (NONE,q)
  | ((hd::_,_) as q) -> (SOME hd,q)
  | ((_,[hd]) as q) -> (SOME hd,([],[hd]))
  | ((_,hd::tl) as q) -> first_elem(rev tl, [hd]);;
        
let last_elem = function
    ((_,hd::_) as q) -> (SOME hd,q)
  | q -> (NONE,q);;

