(* $Id: xlib.mli,v 1.10 92/10/08 16:45:08 ddr Exp $ *)

type Display and Colormap and GC and Visual and XEvent and Drawable
  and XFontStruct and Font and XSetWindowAttributes and XGCValues
  and XWindowChanges and XColor and XWMHints
  and XAnyEvent and XEvent and XImage and XPoint
  and XCrossingEvent and XButtonEvent and XConfigureEvent
  and XGraphicsExposeEvent and XExposeEvent and XKeyEvent
  and XMotionEvent and XSizeHints and LongRef and Cursor
  and XKeyboardControl and XKeyboardState and XID;;
type Window == Drawable and Pixmap == Drawable;;
type GContext == XID;;
type Atom == int and Time == int and KeySym == int and Status == int;;
type C_String;;
type MLimage;;
type fd_set;;

exception X_failure of string;;
exception X_io_error of string * int;;

value Above : int;;
value Always : int;;
value Button1Mask : int;;
value Button2Mask : int;;
value Button3Mask : int;;
value Button4Mask : int;;
value Button5Mask : int;;
value Button2MotionMask : int;;
value ButtonMotionMask : int;;
value ButtonPress : int;;
value ButtonPressMask : int;;
value ButtonRelease : int;;
value ButtonReleaseMask : int;;
value CWBackingStore : int;;
value CWOverrideRedirect : int;;
value CWSaveUnder : int;;
value CWStackMode : int;;
value CWX : int;;
value CWY : int;;
value CapButt : int;;
value CapNotLast : int;;
value CapProjecting : int;;
value CapRound : int;;
value ConfigureNotify : int;;
value ControlMask : int;;
value Convex : int;;
value CoordModeOrigin : int;;
value CurrentTime : Time;;
value DirectColor : int;;
value DoBlue : int;;
value DoGreen : int;;
value DoRed : int;;
value EnterNotify : int;;
value EnterWindowMask : int;;
value Expose : int;;
value ExposureMask : int;;
value FillOpaqueStippled : int;;
value FillSolid : int;;
value FillStippled : int;;
value FillTiled : int;;
value GCBackground : int;;
value GCCapStyle : int;;
value GCFont : int;;
value GCForeground : int;;
value GCLineWidth : int;;
value GraphicsExpose : int;;
value GrayScale : int;;
value InputHint : int;;
value JoinBevel : int;;
value JoinMiter : int;;
value KBBellDuration : int;;
value KBBellPercent : int;;
value KBBellPitch : int;;
value KeyPress : int;;
value KeyPressMask : int;;
value LSBFirst : int;;
value LeaveNotify : int;;
value LeaveWindowMask : int;;
value LineSolid : int;;
value MotionNotify : int;;
value NoExpose : int;;
value OwnerGrabButtonMask : int;;
value PPosition : int;;
value PSize : int;;
value PointerMotionMask : int;;
value PseudoColor : int;;
value ShiftMask : int;;
value StaticColor : int;;
value StaticGray : int;;
value StructureNotifyMask : int;;
value TrueColor : int;;
value USPosition : int;;
value USSize : int;;
value XA_PRIMARY : Atom;;
value XNone : Drawable;;
value XYBitmap : int;;
value ZPixmap : int;;

(* X functions *)
value XAllocColor : Display * Colormap * XColor -> Status = 1 "ML_XAllocColor";;
value XAllocColorCells : Display * Colormap * int * LongRef * int * LongRef * int -> Status = 1 "ML_XAllocColorCells";;
value XBell : Display * int -> unit = 1 "ML_XBell";;
value XBlackPixel : Display * int -> int = 1 "ML_XBlackPixel";;
value XChangeKeyboardControl : Display * int * XKeyboardControl -> unit = 1 "ML_XChangeKeyboardControl";;
value XChangeWindowAttributes : Display * Window * int * XSetWindowAttributes -> unit = 1 "ML_XChangeWindowAttributes";;
value XCheckMaskEvent : Display * int * XEvent -> int = 1 "ML_XCheckMaskEvent";;
value XClearArea : Display * Window * int * int * int * int * int -> unit = 1 "ML_XClearArea";;
value XClearWindow : Display * Window -> unit = 1 "ML_XClearWindow";;
value XCloseDisplay : Display -> unit = 1 "ML_XCloseDisplay";;
value XConfigureWindow : Display * Window * int * XWindowChanges -> unit = 1 "ML_XConfigureWindow";;
value XConnectionNumber : Display -> int = 1 "ML_XConnectionNumber";;
value XCopyArea : Display * Drawable * Drawable * GC * int * int * int * int * int * int -> unit = 1 "ML_XCopyArea";;
value XCreateBitmapFromData : Display * Drawable * string * int * int -> Pixmap = 1 "ML_XCreateBitmapFromData";;
value XCreateFontCursor : Display * int -> Cursor = 1 "ML_XCreateFontCursor";;
value XCreateGC : Display * Window * int * XGCValues -> GC = 1 "ML_XCreateGC";;
value XCreateImageNullData : Display * Visual * int * int * int * int * int * int * int -> XImage = 1 "ML_XCreateImageNullData";;
value XCreatePixmap : Display * Drawable * int * int * int -> Pixmap = 1 "ML_XCreatePixmap";;
value XCreatePixmapCursor : Display * Pixmap * Pixmap * XColor * XColor * int * int -> Cursor = 1 "ML_XCreatePixmapCursor";;
value XCreatePixmapFromBitmapData : Display * Drawable * string * int * int * int * int * int -> Pixmap = 1 "ML_XCreatePixmapFromBitmapData";;
value XCreateSimpleWindow : Display * Window * int * int * int * int * int * int * int -> Window = 1 "ML_XCreateSimpleWindow";;
value XDefaultColormap : Display * int -> Colormap = 1 "ML_XDefaultColormap";;
value XDefaultDepth : Display * int -> int = 1 "ML_XDefaultDepth";;
value XDefaultGC : Display * int -> GC = 1 "ML_XDefaultGC";;
value XDefaultRootWindow : Display -> Window = 1 "ML_XDefaultRootWindow";;
value XDefaultScreen : Display -> int = 1 "ML_XDefaultScreen";;
value XDefaultVisual : Display * int -> Visual = 1 "ML_XDefaultVisual";;
value XDefineCursor : Display * Window * Cursor -> unit = 1 "ML_XDefineCursor";;
value XDestroyWindow : Display * Window -> unit = 1 "ML_XDestroyWindow";;
value XDisplayHeight : Display * int -> int = 1 "ML_XDisplayHeight";;
value XDisplayName : string -> C_String = 1 "ML_XDisplayName";;
value XDisplayWidth : Display * int -> int = 1 "ML_XDisplayWidth";;
value XDrawArc : Display * Drawable * GC * int * int * int * int * int * int -> unit = 1 "ML_XDrawArc";;
value XDrawImageString : Display * Drawable * GC * int * int * string * int -> unit = 1 "ML_XDrawImageString";;
value XDrawLine : Display * Drawable * GC * int * int * int * int -> unit = 1 "ML_XDrawLine";;
value XDrawLines : Display * Drawable * GC * XPoint * int * int -> unit = 1 "ML_XDrawLines";;
value XDrawPoint : Display * Drawable * GC * int * int -> unit = 1 "ML_XDrawPoint";;
value XDrawRectangle : Display * Drawable * GC * int * int * int * int -> unit = 1 "ML_XDrawRectangle";;
value XDrawString : Display * Drawable * GC * int * int * string * int -> unit = 1 "ML_XDrawString";;
value XFetchBytes : Display * int ref -> C_String = 1 "ML_XFetchBytes";;
value XFillArc : Display * Drawable * GC * int * int * int * int * int * int -> unit = 1 "ML_XFillArc";;
value XFillPolygon : Display * Drawable * GC * XPoint * int * int * int -> unit = 1 "ML_XFillPolygon";;
value XFillRectangle : Display * Drawable * GC * int * int * int * int -> unit = 1 "ML_XFillRectangle";;
value XFreeCursor : Display * Cursor -> unit = 1 "ML_XFreeCursor";;
value XFreeFont : Display * XFontStruct -> unit = 1 "ML_XFreeFont";;
value XFreeFontInfoSpec : XFontStruct -> unit = 1 "ML_XFreeFontInfoSpec";;
value XFreeGC : Display * GC -> unit = 1 "ML_XFreeGC";;
value XFreePixmap : Display * Pixmap -> unit = 1 "ML_XFreePixmap";;
value XGContextFromGC : GC -> GContext = 1 "ML_XGContextFromGC";;
value XGetDefault : Display * string * string -> C_String = 1 "ML_XGetDefault";;
value XGetImage : Display * Drawable * int * int * int * int * int * int -> XImage = 1 "ML_XGetImage";;
value XGetKeyboardControl : Display * XKeyboardState -> unit = 1 "ML_XGetKeyboardControl";;
value XGetPixel : XImage * int * int -> int = 1 "ML_XGetPixel";;
value XGetPixelWithData : XImage * string * int * int -> int = 1 "ML_XGetPixelWithData";;
value XKeycodeToKeysym : Display * int * int -> KeySym = 1 "ML_XKeycodeToKeysym";;
value XLoadQueryFont : Display * string -> XFontStruct = 1 "ML_XLoadQueryFont";;
value XMapRaised : Display * Window -> unit = 1 "ML_XMapRaised";;
value XMapSubwindows: Display * Window -> unit = 1 "ML_XMapSubwindows";;
value XMapWindow : Display * Window -> unit = 1 "ML_XMapWindow";;
value XMoveResizeWindow : Display * Window * int * int * int * int -> unit = 1 "ML_XMoveResizeWindow";;
value XMoveWindow : Display * Window * int * int -> unit = 1 "ML_XMoveWindow";;
value XNextEvent : Display * XEvent -> unit = 1 "ML_XNextEvent";;
value XOpenDisplay : string -> Display = 1 "ML_XOpenDisplay";;
value XPending : Display -> int = 1 "ML_XPending";;
value XPutImage : Display * Drawable * GC * XImage * int * int * int * int * int * int -> unit = 1 "ML_XPutImage";;
value XPutImageWithData : Display * Drawable * GC * XImage * string * int * int * int * int * int * int -> unit = 1 "ML_XPutImageWithData";;
value XQueryColor : Display * Colormap * XColor -> unit = 1 "ML_XQueryColor";;
value XQueryFont : Display * XID -> XFontStruct = 1 "ML_XQueryFont";;
value XQueryPointer : Display * Window * Window ref * Window ref * int ref * int ref * int ref * int ref * int ref -> int = 1 "ML_XQueryPointer";;
value XRaiseWindow : Display * Window -> unit = 1 "ML_XRaiseWindow";;
value XReparentWindow : Display * Window * Window * int * int -> unit = 1 "ML_XReparentWindow";;
value XResizeWindow : Display * Window * int * int -> unit = 1 "ML_XResizeWindow";;
value XSelectInput : Display * Window * int -> unit = 1 "ML_XSelectInput";;
value XSetClassHint : Display * Window * string * string -> unit = 1 "ML_XSetClassHint";;
value XSetClipMask : Display * GC * Pixmap -> unit = 1 "ML_XSetClipMask";;
value XSetClipOrigin : Display * GC * int * int -> unit = 1 "ML_XSetClipOrigin";;
value XSetFillStyle : Display * GC * int -> unit = 1 "ML_XSetFillStyle";;
value XSetFont : Display * GC * Font -> unit = 1 "ML_XSetFont";;
value XSetForeground : Display * GC * int -> unit = 1 "ML_XSetForeground";;
value XSetIconName : Display * Window * string -> unit = 1 "ML_XSetIconName";;
value XSetLineAttributes : Display * GC * int * int * int * int -> unit = 1 "ML_XSetLineAttributes";;
value XSetNormalHints : Display * Window * XSizeHints -> unit = 1 "ML_XSetNormalHints";;
value XSetSelectionOwner : Display * Atom * Window * Time -> unit = 1 "ML_XSetSelectionOwner";;
value XSetStandardProperties : Display * Window * string * string * Pixmap * string * XSizeHints -> unit = 1 "ML_XSetStandardProperties";;
value XSetStipple : Display * GC * Pixmap -> unit = 1 "ML_XSetStipple";;
value XSetTile : Display * GC * Pixmap -> unit = 1 "ML_XSetTile";;
value XSetTransientForHint : Display * Window * Window -> unit = 1 "ML_XSetTransientForHint";;
value XSetTSOrigin : Display * GC * int * int -> unit = 1 "ML_XSetTSOrigin";;
value XSetWindowBackground : Display * Window * int -> unit = 1 "ML_XSetWindowBackground";;
value XSetWindowBackgroundPixmap : Display * Window * Pixmap -> unit = 1 "ML_XSetWindowBackgroundPixmap";;
value XSetWMHints : Display * Window * XWMHints -> unit = 1 "ML_XSetWMHints";;
value XStoreBytes : Display * string * int -> unit = 1 "ML_XStoreBytes";;
value XStoreColor : Display * Colormap * XColor -> unit = 1 "ML_XStoreColor";;
value XStoreName : Display * Window * string -> unit = 1 "ML_XStoreName";;
value XSync : Display * int -> unit = 1 "ML_XSync";;
value XTextWidth : XFontStruct * string * int -> int = 1 "ML_XTextWidth";;
value XUndefineCursor : Display * Window -> unit = 1 "ML_XUndefineCursor";;
value XUnmapWindow : Display * Window -> unit = 1 "ML_XUnmapWindow";;
value XWhitePixel : Display * int -> int = 1 "ML_XWhitePixel";;

(* alloc C structs *)
value alloc_XColor : unit -> XColor = 1 "ML_alloc_XColor";;
value alloc_XEvent : unit -> XEvent = 1 "ML_alloc_XEvent";;
value alloc_XGCValues : unit -> XGCValues = 1 "ML_alloc_XGCValues";;
value alloc_XKeyboardControl : unit -> XKeyboardControl = 1 "ML_alloc_XKeyboardControl";;
value alloc_XKeyboardState : unit -> XKeyboardState = 1 "ML_alloc_XKeyboardState";;
value alloc_XPoint : int -> XPoint = 1 "ML_alloc_XPoint";;
value alloc_XSetWindowAttributes : unit -> XSetWindowAttributes = 1 "ML_alloc_XSetWindowAttributes";;
value alloc_XSizeHints : unit -> XSizeHints = 1 "ML_alloc_XSizeHints";;
value alloc_XWindowChanges : unit -> XWindowChanges = 1 "ML_alloc_XWindowChanges";;
value alloc_XWMHints : unit -> XWMHints = 1 "ML_alloc_XWMHints";;

(* get C structs *)
value Visual_class : Visual -> int = 1 "ML_Visual_class";;
value XAnyEvent_window : XAnyEvent -> Window = 1 "ML_XAnyEvent_window";;
value XButtonEvent_button : XButtonEvent -> int = 1 "ML_XButtonEvent_button";;
value XButtonEvent_x : XButtonEvent -> int = 1 "ML_XButtonEvent_x";;
value XButtonEvent_x_root : XButtonEvent -> int = 1 "ML_XButtonEvent_x_root";;
value XButtonEvent_y : XButtonEvent -> int = 1 "ML_XButtonEvent_y";;
value XButtonEvent_y_root : XButtonEvent -> int = 1 "ML_XButtonEvent_y_root";;
value XColor_blue : XColor -> int = 1 "ML_XColor_blue";;
value XColor_green : XColor -> int = 1 "ML_XColor_green";;
value XColor_pixel : XColor -> int = 1 "ML_XColor_pixel";;
value XColor_red : XColor -> int = 1 "ML_XColor_red";;
value XConfigureEvent_height : XConfigureEvent -> int = 1 "ML_XConfigureEvent_height";;
value XConfigureEvent_width : XConfigureEvent -> int = 1 "ML_XConfigureEvent_width";;
value XConfigureEvent_x : XConfigureEvent -> int = 1 "ML_XConfigureEvent_x";;
value XConfigureEvent_y : XConfigureEvent -> int = 1 "ML_XConfigureEvent_y";;
value XCrossingEvent_x : XCrossingEvent -> int = 1 "ML_XCrossingEvent_x";;
value XCrossingEvent_x_root : XCrossingEvent -> int = 1 "ML_XCrossingEvent_x_root";;
value XCrossingEvent_y : XCrossingEvent -> int = 1 "ML_XCrossingEvent_y";;
value XCrossingEvent_y_root : XCrossingEvent -> int = 1 "ML_XCrossingEvent_y_root";;
value XEvent_type : XEvent -> int = 1 "ML_XEvent_type";;
value XEvent_xany : XEvent -> XAnyEvent = 1 "ML_XEvent_xany";;
value XEvent_xbutton : XEvent -> XButtonEvent = 1 "ML_XEvent_xbutton";;
value XEvent_xconfigure : XEvent -> XConfigureEvent = 1 "ML_XEvent_xconfigure";;
value XEvent_xcrossing : XEvent -> XCrossingEvent = 1 "ML_XEvent_xcrossing";;
value XEvent_xexpose : XEvent -> XExposeEvent = 1 "ML_XEvent_xexpose";;
value XEvent_xgraphicsexpose : XEvent -> XGraphicsExposeEvent = 1 "ML_XEvent_xgraphicsexpose";;
value XEvent_xkey : XEvent -> XKeyEvent = 1 "ML_XEvent_xkey";;
value XEvent_xmotion : XEvent -> XMotionEvent = 1 "ML_XEvent_xmotion";;
value XExposeEvent_height : XExposeEvent -> int = 1 "ML_XExposeEvent_height";;
value XExposeEvent_width : XExposeEvent -> int = 1 "ML_XExposeEvent_width";;
value XExposeEvent_x : XExposeEvent -> int = 1 "ML_XExposeEvent_x";;
value XExposeEvent_y : XExposeEvent -> int = 1 "ML_XExposeEvent_y";;
value XFontStruct_ascent : XFontStruct -> int = 1 "ML_XFontStruct_ascent";;
value XFontStruct_descent : XFontStruct -> int = 1 "ML_XFontStruct_descent";;
value XFontStruct_fid : XFontStruct -> Font = 1 "ML_XFontStruct_fid";;
value XFontStruct_max_bounds_ascent : XFontStruct -> int = 1 "ML_XFontStruct_max_bounds_ascent";;
value XFontStruct_max_bounds_descent : XFontStruct -> int = 1 "ML_XFontStruct_max_bounds_descent";;
value XGraphicsExposeEvent_count : XGraphicsExposeEvent -> int = 1 "ML_XGraphicsExposeEvent_count";;
value XGraphicsExposeEvent_height : XGraphicsExposeEvent -> int = 1 "ML_XGraphicsExposeEvent_height";;
value XGraphicsExposeEvent_width : XGraphicsExposeEvent -> int = 1 "ML_XGraphicsExposeEvent_width";;
value XGraphicsExposeEvent_x : XGraphicsExposeEvent -> int = 1 "ML_XGraphicsExposeEvent_x";;
value XGraphicsExposeEvent_y : XGraphicsExposeEvent -> int = 1 "ML_XGraphicsExposeEvent_y";;
value XImage_data : XImage -> C_String = 1 "ML_XImage_data";;
value XKeyboardState_bell_duration : XKeyboardState -> int = 1 "ML_XKeyboardState_bell_duration";;
value XKeyboardState_bell_percent : XKeyboardState -> int = 1 "ML_XKeyboardState_bell_percent";;
value XKeyboardState_bell_pitch : XKeyboardState -> int = 1 "ML_XKeyboardState_bell_pitch";;
value XKeyEvent_keycode : XKeyEvent -> int = 1 "ML_XKeyEvent_keycode";;
value XKeyEvent_state : XKeyEvent -> int = 1 "ML_XKeyEvent_state";;
value XMotionEvent_x : XMotionEvent -> int = 1 "ML_XMotionEvent_x";;
value XMotionEvent_y : XMotionEvent -> int = 1 "ML_XMotionEvent_y";;

(* set C structs *)
value set_XColor_blue : int * XColor -> unit = 1 "ML_set_XColor_blue";;
value set_XColor_flags : int * XColor -> unit = 1 "ML_set_XColor_flags";;
value set_XColor_green : int * XColor -> unit = 1 "ML_set_XColor_green";;
value set_XColor_pixel : int * XColor -> unit = 1 "ML_set_XColor_pixel";;
value set_XColor_red : int * XColor -> unit = 1 "ML_set_XColor_red";;
value set_XGCValues_background : int * XGCValues -> unit = 1 "ML_set_XGCValues_background";;
value set_XGCValues_cap_style : int * XGCValues -> unit = 1 "ML_set_XGCValues_cap_style";;
value set_XGCValues_font : Font * XGCValues -> unit = 1 "ML_set_XGCValues_font";;
value set_XGCValues_foreground : int * XGCValues -> unit = 1 "ML_set_XGCValues_foreground";;
value set_XGCValues_line_width : int * XGCValues -> unit = 1 "ML_set_XGCValues_line_width";;
value set_XImage_bitmap_bit_order : int * XImage -> unit = 1 "ML_set_XImage_bitmap_bit_order";;
value set_XImage_byte_order : int * XImage -> unit = 1 "ML_set_XImage_byte_order";;
value set_XKeyboardControl_bell_duration : int * XKeyboardControl  -> unit = 1 "ML_set_XKeyboardControl_bell_duration";;
value set_XKeyboardControl_bell_percent : int * XKeyboardControl  -> unit = 1 "ML_set_XKeyboardControl_bell_percent";;
value set_XKeyboardControl_bell_pitch : int * XKeyboardControl  -> unit = 1 "ML_set_XKeyboardControl_bell_pitch";;
value set_XPoint_x : int * XPoint * int -> unit = 1 "ML_set_XPoint_x";;
value set_XPoint_y : int * XPoint * int -> unit = 1 "ML_set_XPoint_y";;
value set_XSetWindowAttributes_backing_store : int * XSetWindowAttributes -> unit = 1 "ML_set_XSetWindowAttributes_backing_store";;
value set_XSetWindowAttributes_override_redirect : int * XSetWindowAttributes -> unit = 1 "ML_set_XSetWindowAttributes_override_redirect";;
value set_XSetWindowAttributes_save_under : int * XSetWindowAttributes -> unit = 1 "ML_set_XSetWindowAttributes_save_under";;
value set_XSizeHints_flags : int * XSizeHints -> unit = 1 "ML_set_XSizeHints_flags";;
value set_XSizeHints_x : int * XSizeHints -> unit = 1 "ML_set_XSizeHints_x";;
value set_XSizeHints_y : int * XSizeHints -> unit = 1 "ML_set_XSizeHints_y";;
value set_XSizeHints_width : int * XSizeHints -> unit = 1 "ML_set_XSizeHints_width";;
value set_XSizeHints_height : int * XSizeHints -> unit = 1 "ML_set_XSizeHints_height";;
value set_XWMHints_flags : int * XWMHints -> unit = 1 "ML_set_XWMHints_flags";;
value set_XWMHints_input : int * XWMHints -> unit = 1 "ML_set_XWMHints_input";;
value set_XWindowChanges_stack_mode : int * XWindowChanges -> unit = 1 "ML_set_XWindowChanges_stack_mode";;
value set_XWindowChanges_x : int * XWindowChanges -> unit = 1 "ML_set_XWindowChanges_x";;
value set_XWindowChanges_y : int * XWindowChanges -> unit = 1 "ML_set_XWindowChanges_y";;

value C_String_length : C_String -> int = 1 "ML_C_String_length";;
value FD_ISSET : int * fd_set -> int = 1 "ML_FD_ISSET";;
value FD_SET : int * fd_set -> unit = 1 "ML_FD_SET";;
value FD_ZERO : fd_set -> unit = 1 "ML_FD_ZERO";;

value MLimage_of_XImage : XImage -> MLimage = 1 "ML_MLimage_of_XImage";;

value alloc_LongRef : unit -> LongRef = 1 "ML_alloc_LongRef";;
value LongRef_value : LongRef -> int = 1 "ML_LongRef_value";;

value alloc_fd_set : unit -> fd_set = 1 "ML_alloc_fd_set";;
value free_C_String : C_String -> unit = 1 "ML_free_C_String";;
value fselect : int * fd_set * int -> int = 1 "ML_fselect";;
value is_null_Display : Display -> bool = 1 "ML_is_null_pt";;
value is_null_XFontStruct : XFontStruct -> bool = 1 "ML_is_null_pt";;
value is_null_C_String : C_String -> bool = 1 "ML_is_null_pt";;
value set_xerror_exn : exn * exn -> unit = 1 "ML_set_xerror_exn";;
value string_of_C_String : C_String * int -> string = 1 "ML_string_of_C_String";;
