(* $Id: xlib.ml,v 1.5 92/10/08 16:45:07 ddr Exp $ *)

set_xerror_exn (X_failure "", X_io_error ("", 0));;

let Bit_In_Long n =
  let x = ref 1 and 
      i = ref n in
    while (decr(i); !i) >= 0 do
	x := !x * 2
    done;
    !x
;;

let Bit_In_Int n =
  let x = ref 1 and 
      i = ref n in
    while (decr(i); !i) >= 0 do
	x := !x * 2
    done;
    !x
;;

type Drawable == int;;
let XNone = 0;;

let GCFunction              = Bit_In_Long(0)
and GCPlaneMask             = Bit_In_Long(1)
and GCForeground            = Bit_In_Long(2)
and GCBackground            = Bit_In_Long(3)
and GCLineWidth             = Bit_In_Long(4)
and GCLineStyle             = Bit_In_Long(5)
and GCCapStyle              = Bit_In_Long(6)
and GCJoinStyle		    = Bit_In_Long(7)
and GCFillStyle		    = Bit_In_Long(8)
and GCFillRule		    = Bit_In_Long(9) 
and GCTile		    = Bit_In_Long(10)
and GCStipple		    = Bit_In_Long(11)
and GCTileStipXOrigin	    = Bit_In_Long(12)
and GCTileStipYOrigin	    = Bit_In_Long(13)
and GCFont 		    = Bit_In_Long(14)
and GCSubwindowMode	    = Bit_In_Long(15)
and GCGraphicsExposures     = Bit_In_Long(16)
and GCClipXOrigin	    = Bit_In_Long(17)
and GCClipYOrigin	    = Bit_In_Long(18)
and GCClipMask		    = Bit_In_Long(19)
and GCDashOffset	    = Bit_In_Long(20)
and GCDashList		    = Bit_In_Long(21)
and GCArcMode		    = Bit_In_Long(22)
;;

let XYBitmap		= (0)	(* depth 1, XYFormat *)
and XYPixmap		= (1)	(* depth == drawable depth *)
and ZPixmap		= (2)	(* depth == drawable depth *)
;;

let LSBFirst		= (0)
and MSBFirst		= (1)
;;

let NoEventMask			= 0
and KeyPressMask		= Bit_In_Long(0)
and KeyReleaseMask		= Bit_In_Long(1)
and ButtonPressMask		= Bit_In_Long(2)
and ButtonReleaseMask		= Bit_In_Long(3)
and EnterWindowMask		= Bit_In_Long(4)
and LeaveWindowMask		= Bit_In_Long(5)
and PointerMotionMask		= Bit_In_Long(6)
and PointerMotionHintMask	= Bit_In_Long(7)
and Button1MotionMask		= Bit_In_Long(8)
and Button2MotionMask		= Bit_In_Long(9)
and Button3MotionMask		= Bit_In_Long(10)
and Button4MotionMask		= Bit_In_Long(11)
and Button5MotionMask		= Bit_In_Long(12)
and ButtonMotionMask		= Bit_In_Long(13)
and KeymapStateMask		= Bit_In_Long(14)
and ExposureMask		= Bit_In_Long(15)
and VisibilityChangeMask	= Bit_In_Long(16)
and StructureNotifyMask		= Bit_In_Long(17)
and ResizeRedirectMask		= Bit_In_Long(18)
and SubstructureNotifyMask	= Bit_In_Long(19)
and SubstructureRedirectMask	= Bit_In_Long(20)
and FocusChangeMask		= Bit_In_Long(21)
and PropertyChangeMask		= Bit_In_Long(22)
and ColormapChangeMask		= Bit_In_Long(23)
and OwnerGrabButtonMask		= Bit_In_Long(24)
;;

let KeyPress		= (2)
and KeyRelease		= (3)
and ButtonPress		= (4)
and ButtonRelease	= (5)
and MotionNotify	= (6)
and EnterNotify		= (7)
and LeaveNotify		= (8)
and FocusIn		= (9)
and FocusOut		= (10)
and KeymapNotify	= (11)
and Expose		= (12)
and GraphicsExpose	= (13)
and NoExpose		= (14)
and VisibilityNotify	= (15)
and CreateNotify	= (16)
and DestroyNotify	= (17)
and UnmapNotify		= (18)
and MapNotify		= (19)
and MapRequest		= (20)
and ReparentNotify	= (21)
and ConfigureNotify	= (22)
and ConfigureRequest	= (23)
and GravityNotify	= (24)
and ResizeRequest	= (25)
and CirculateNotify	= (26)
and CirculateRequest	= (27)
and PropertyNotify	= (28)
and SelectionClear	= (29)
and SelectionRequest	= (30)
and SelectionNotify	= (31)
and ColormapNotify	= (32)
and ClientMessage	= (33)
and MappingNotify	= (34)
and LASTEvent		= (35)
;;

let Button1Mask		= Bit_In_Int(8)
and Button2Mask		= Bit_In_Int(9)
and Button3Mask		= Bit_In_Int(10)
and Button4Mask		= Bit_In_Int(11)
and Button5Mask		= Bit_In_Int(12)
and AnyModifier		= Bit_In_Int(15)  (* used in GrabButton, GrabKey *)
;;

let LineSolid			= (0)
and LineOnOffDash		= (1)
and LineDoubleDash		= (2)
;;

let CapNotLast			= (0)
and CapButt			= (1)
and CapRound			= (2)
and CapProjecting		= (3)
;;

let JoinMiter			= (0)
and JoinRound			= (1)
and JoinBevel			= (2)
;;

let CWBackPixmap		= Bit_In_Long(0)
and CWBackPixel			= Bit_In_Long(1)
and CWBorderPixmap		= Bit_In_Long(2)
and CWBorderPixel	        = Bit_In_Long(3)
and CWBitGravity		= Bit_In_Long(4)
and CWWinGravity		= Bit_In_Long(5)
and CWBackingStore      	= Bit_In_Long(6)
and CWBackingPlanes	        = Bit_In_Long(7)
and CWBackingPixel	        = Bit_In_Long(8)
and CWOverrideRedirect		= Bit_In_Long(9)
and CWSaveUnder			= Bit_In_Long(10)
and CWEventMask			= Bit_In_Long(11)
and CWDontPropagate	        = Bit_In_Long(12)
and CWColormap			= Bit_In_Long(13)
and CWCursor	       		= Bit_In_Long(14)
;;

let CWX				= Bit_In_Int(0)
and CWY				= Bit_In_Int(1)
and CWWidth			= Bit_In_Int(2)
and CWHeight			= Bit_In_Int(3)
and CWBorderWidth		= Bit_In_Int(4)
and CWSibling			= Bit_In_Int(5)
and CWStackMode			= Bit_In_Int(6)
;;

let Above                   = (0)
and Below                   = (1)
and TopIf                   = (2)
and BottomIf                = (3)
and Opposite                = (4)
;;

let FillSolid			= (0)
and FillTiled			= (1)
and FillStippled		= (2)
and FillOpaqueStippled		= (3)
;;

let USPosition	= (1)	 (* user specified x, y *)
and USSize	= (2) (* user specified width, height *)
and PPosition	= (4) (* program specified position *)
and PSize	= (8) (* program specified size *)
;;

let NotUseful               = (0)
and WhenMapped              = (1)
and Always                  = (2)
;;

let DoRed			= 1
and DoGreen			= 2
and DoBlue			= 4
;;

let CurrentTime   = 0;;

let XA_PRIMARY    = (1);;

let ShiftMask		= Bit_In_Int(0)
and LockMask		= Bit_In_Int(1)
and ControlMask		= Bit_In_Int(2)
and Mod1Mask		= Bit_In_Int(3)
and Mod2Mask		= Bit_In_Int(4)
and Mod3Mask		= Bit_In_Int(5)
and Mod4Mask		= Bit_In_Int(6)
and Mod5Mask		= Bit_In_Int(7)
;;

let Complex	= (0)    (* paths may intersect *)
and Nonconvex	= (1)    (* no paths intersect, but not convex *)
and Convex	= (2)    (* wholly convex *)
;;

let CoordModeOrigin	= (0)  (* relative to the origin *)
and CoordModePrevious   = (1)  (* relative to previous point *)
;;

let StaticGray		= (0)
and GrayScale		= (1)
and StaticColor		= (2)
and PseudoColor		= (3)
and TrueColor		= (4)
and DirectColor		= (5)
;;

let InputHint 		= (1)
and StateHint 		= (2)
and IconPixmapHint	= (4)
and IconWindowHint	= (8)
and IconPositionHint 	= (16)
and IconMaskHint	= (32)
and WindowGroupHint	= (64)
and AllHints 		= (127)
(* InputHint|StateHint|IconPixmapHint|IconWindowHint| 
IconPositionHint|IconMaskHint|WindowGroupHint *)
;;

(* masks for ChangeKeyboardControl *)
let KBKeyClickPercent		= Bit_In_Long(0)
and KBBellPercent		= Bit_In_Long(1)
and KBBellPitch			= Bit_In_Long(2)
and KBBellDuration		= Bit_In_Long(3)
and KBLed			= Bit_In_Long(4)
and KBLedMode			= Bit_In_Long(5)
and KBKey			= Bit_In_Long(6)
and KBAutoRepeatMode		= Bit_In_Long(7)
;;
