(* $Id: util.ml,v 1.4 92/10/08 16:45:05 ddr Exp $ *)

#open "rtdef";;
#open "xlib";;
#open "std";;

let dynamo_tag (a : 'a) b r =
  (fun x (y : 'a) -> r := Some x; b),
  (fun f ->
    r := None;
    let v = f a in
    match !r with
      None -> failwith ("bad type \""^v^"\", should be \""^b^"\"")
    | Some x -> x
  )
;;

let dynamo_local_info = dynamo_tag C'LI
and dynamo_global_info = dynamo_tag C'GI
;;

let ffail _ = failwith "fail";;
let no_info _ = ""
and no_user_info = C'UI (fun _ -> failwith "fail")
and any_fun _ = ffail()
;;

let mallocated_var alloc_fun r _ =
(* to allocate at run time *)
  match !r with
    None -> let v = alloc_fun () in r := Some v; v
  | Some v -> v
;;

let gstr =
  let gstr = ref None in
function () ->
  match !gstr with
    Some gstr -> gstr
  | None ->
      let str = {
        xgcv = alloc_XGCValues ();
        xev = alloc_XEvent ();
        fds = alloc_fd_set ()
      }
      in
      gstr := Some str;
      str
;;

let add_widget attr win wid =
  let xd = wid.wid_xd in
  hash_add_assoc (win, wid) xd.wid_by_win;
  do_list (function
    C'NameAtt wname ->
      if try
        let _ = hash_assoc wname xd.wid_by_name in true with _ -> false
      then
        failwith ("double definition of name \"" ^ wname ^ "\"");
      hash_add_assoc (wname, wid) xd.wid_by_name
  | _ -> ()
  ) attr;
  wid

and remove_widget attr win wid =
  let xd = wid.wid_xd in
  do_list (function
    C'NameAtt wname -> hash_remove_assoc wname xd.wid_by_name
  | _ -> ()
  ) attr;
  hash_remove_assoc win xd.wid_by_win

and add_ginfo xd wname global_info ginfo =
  hash_add_assoc (wname, (global_info ginfo)) xd.ginfo;
  ginfo

and ginfo xd wname =
  hash_assoc wname xd.ginfo

and remove_ginfo xd wname =
  hash_remove_assoc wname xd.ginfo
;;

let create_window(xd, pwin, x, y, width, height, border, attr, smask) =
  let (bg_att, bd_att) = it_list (fun (bg,bd as att) -> function
    C'BackgroundAtt bg -> (Some bg,bd)
  | C'BorderBackgAtt bd -> (bg,Some bd)
  | _ -> att) (None,None) attr in
  let bg = match bg_att with Some(C'ColorBg c) -> c | _ -> xd.white
  and bd = match bd_att with Some(C'ColorBg c) -> c | _ -> xd.black in
  let win = XCreateSimpleWindow(xd.dpy, pwin,
    x, y,
    (max width 1), (max height 1), (max border 0),
    bd, bg
  ) in
  let bg = match bg_att with
    Some C'NoneBg -> Some XNone
  | Some(C'PixmapBg p) -> Some p
  | _ -> None in
  (match bg with Some bg -> XSetWindowBackgroundPixmap(xd.dpy, win, bg)
  | None -> ());
  XSelectInput(xd.dpy, win, smask);
  win
;;

let set_wm_and_class_hints =
  let xwmh = mallocated_var alloc_XWMHints (ref None) in
function wid ->
  let xd = wid.wid_xd
  and xwmh = xwmh() in
  set_XWMHints_input(1, xwmh);
  set_XWMHints_flags(InputHint, xwmh);
  XSetWMHints(xd.dpy, wid.win, xwmh);
  XSetClassHint (xd.dpy, wid.win, "camlrt", "Camlrt")
;;

let set_std_prop =
  let xsh = mallocated_var alloc_XSizeHints (ref None) in
function (wid, wname, iname, x, y, width, height, flags) ->
  let xd = wid.wid_xd
  and xsh = xsh () in
  set_XSizeHints_x(x, xsh);
  set_XSizeHints_y(y, xsh);
  set_XSizeHints_width(width, xsh);
  set_XSizeHints_height(height, xsh);
  set_XSizeHints_flags(flags, xsh);
  XSetStandardProperties (
    xd.dpy, wid.win, wname, iname, XNone,
    sys__command_line.(0), xsh
  )
;;

