(* $Id: uinfo.ml,v 1.3 92/07/21 16:43:47 ddr Exp $
 *
 * Rogloglo toolkit: user info
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;

let dynamo_user_info b r =
  (fun x -> C'UI (fun () -> r := USome x; b)),
  (fun (C'UI f) ->
    r := UNone;
    let v = f () in
    match !r with
      UNone -> failwith ("bad type \""^v^"\", should be \""^b^"\"")
    | USome x -> x
  )
;;

let user_info s =
  let u_info = dynamo_user_info s in
function r ->
  let f, g = u_info r in
  f, (fun wid -> g wid.user_info)
;;

let rt_set_user_info(wid, ui) =
  wid.user_info <- ui
;;
