(* $Id: test.ml,v 1.5 92/08/25 13:17:17 ddr Exp $
 *
 * Rogloglo Toolkit: test
 *)

#open "rt";;
#open "time";;

let line_buff = create_string 200;;
let max x y = if x > y then x else y
and min x y = if x > y then y else x
and message s = print_string s; print_newline()
and prefix quo x y = x / y
and read ic len = let s = make_string len ` ` in let _ = input ic s 0 len in s
and S f g x = f x (g x)
and K x y = x
and B f g x = f (g x)
and add x y = x + y
and read_line ic = sub_string line_buff 0 (input_rec 0
  where rec input_rec i =
    match (input_char ic) with
      `\n` -> i
    | c -> set_nth_char line_buff i c; input_rec (succ i))
;;
let iterate f = iterate_f
  where rec iterate_f n x =
    if n <= 0 then x else iterate_f (pred n) (f x)
;;
let implode_ascii l =
  let len = list_length l in
  let s = make_string len ` ` in
  let _ = iterate (fun (i,hd::tl) ->
    set_nth_char s i (char_of_int hd);
    (i+1, tl)
  | _ -> failwith "fail"
  ) len (0, l) in
  s
;;

let hex_string hstr =
  let len = string_length hstr
  and hex = function
    `0`..`9` as c -> int_of_char c - int_of_char `0`
  | `a`..`f` as c -> int_of_char c - int_of_char `a` + 10
  | `A`..`F` as c -> int_of_char c - int_of_char `A` + 10
(*
    `0`|`1`|`2`|`3`|`4`|`5`|`6`|`7`|`8`|`9` as c -> int_of_char c - int_of_char `0`
  | `a`|`b`|`c`|`d`|`e`|`f` as c -> int_of_char c - int_of_char `a` + 10
  | `A`|`B`|`C`|`D`|`E`|`F` as c -> int_of_char c - int_of_char `A` + 10
*)
  | _ -> failwith "hex_string" in
  let rec iter str i =
    if i >= len then str
    else if nth_char hstr i == ` ` then iter str (i+1)
    else if nth_char hstr i == `\n` then iter str (i+1)
    else if nth_char hstr i == `,` then iter str (i+1)
    else if nth_char hstr i == `0` & nth_char hstr (i+1) == `x` then (
      iter(
        str ^ make_string 1 (
          char_of_int (
            hex (nth_char hstr (i+2)) * 16 + hex (nth_char hstr (i+3))
          )
        )
      )
      (i+4)
    )
    else failwith "hex_string"
  in
  iter "" 0
;;

let curs_width = 42
and curs_height = 61;;
let curs_x = curs_width / 2
and curs_y = curs_height / 2;;
let curs_src = hex_string "
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x02, 0x00,
 0x00, 0x00, 0x80, 0x83, 0x04, 0x00, 0x00, 0x00, 0x70, 0x80, 0x08, 0x00,
 0x00, 0x00, 0x0c, 0x80, 0x10, 0x00, 0x00, 0x80, 0x03, 0x80, 0x20, 0x00,
 0x00, 0x70, 0x00, 0x80, 0x20, 0x00, 0x00, 0x0c, 0x00, 0x80, 0x20, 0x00,
 0x80, 0x03, 0x00, 0x80, 0x20, 0x00, 0x70, 0x00, 0x00, 0x83, 0x20, 0x00,
 0x10, 0x00, 0xe0, 0x82, 0x20, 0x00, 0x10, 0x00, 0x1c, 0x82, 0x20, 0x00,
 0x10, 0x80, 0x03, 0x82, 0x20, 0x00, 0x10, 0x70, 0x00, 0x82, 0x20, 0x00,
 0x10, 0x0c, 0x00, 0x82, 0x20, 0x00, 0x10, 0x0c, 0x00, 0x82, 0x20, 0x00,
 0x10, 0x14, 0x00, 0x83, 0x20, 0x00, 0x10, 0x24, 0xe0, 0x82, 0x20, 0x00,
 0x10, 0x44, 0x1c, 0x82, 0x20, 0x00, 0x10, 0x84, 0x02, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x82, 0x20, 0x00, 0x10, 0x04, 0x01, 0x82, 0x20, 0x00,
 0x10, 0x04, 0x81, 0x85, 0x20, 0x00, 0x10, 0x04, 0x41, 0x88, 0x20, 0x00,
 0x10, 0x04, 0x31, 0x90, 0x20, 0x00, 0x10, 0x04, 0x0d, 0xa0, 0x20, 0x00,
 0x10, 0x04, 0x03, 0xc0, 0x20, 0x00, 0x10, 0x04, 0x01, 0xc0, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x30, 0x20, 0x00, 0x10, 0x04, 0x01, 0x0c, 0x20, 0x00,
 0x10, 0x04, 0x01, 0x03, 0x20, 0x00, 0x10, 0x04, 0xc1, 0x00, 0x20, 0x00,
 0x10, 0x04, 0x31, 0x00, 0x20, 0x00, 0x10, 0x04, 0x0d, 0x00, 0x30, 0x00,
 0x10, 0x04, 0x03, 0x00, 0x0c, 0x00, 0x10, 0x04, 0x00, 0x80, 0x03, 0x00,
 0x10, 0x04, 0x00, 0x70, 0x00, 0x00, 0x10, 0x04, 0x00, 0x0c, 0x00, 0x00,
 0x20, 0x04, 0x80, 0x03, 0x00, 0x00, 0x40, 0x04, 0x60, 0x00, 0x00, 0x00,
 0x80, 0x04, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x85, 0x03, 0x00, 0x00, 0x00,
 0x00, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
 ";;
let curs_mask = hex_string "
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00,
 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00,
 0x00, 0x00, 0xc0, 0xff, 0x0f, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x1f, 0x00,
 0x00, 0x00, 0xff, 0xff, 0x3f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x7f, 0x00,
 0x00, 0xfc, 0xff, 0xff, 0x7f, 0x00, 0x00, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xe0, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x7f, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x1f, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x07, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0x03, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0x83, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xe3, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xfb, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x7f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x0f, 0x00,
 0xf8, 0xff, 0xff, 0xff, 0x01, 0x00, 0xf8, 0xff, 0xff, 0x7f, 0x00, 0x00,
 0xf0, 0xff, 0xff, 0x0f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x01, 0x00, 0x00,
 0xc0, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x80, 0xff, 0x0f, 0x00, 0x00, 0x00,
 0x00, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00
";;

let my_scroll_set vmin vmax shift act (wid, but, val) =
  let oval = (scroll_val wid)-shift in
  let val =
    if but = 1 then oval-1
    else if but = 3 then oval+1
    else val in
  let val = max vmin (min vmax val) in
  if val <> oval then (
    scroll_set(wid, val+shift);
    act val
  )
;;

let my_text_button xd (wid, but, lin, col) =
  match but with
    1 ->
      text_set_mark(wid, lin, col)
  | -1 | 3 ->
      let txt = text_get_text(wid, lin, col) in
      rt_set_cut_buffer(xd, txt)
  | -2 ->
      let txt = rt_get_cut_buffer xd in
      text_send_string(wid, txt)
  | _ ->
      ()
;;

let action wid_named _ =
  message "le bouton \"bouton\" provoque l'appel de cette fonction";
  let main_wid = wid_named "test" in
  print_string " x="; print_int (widget_x main_wid);
  print_string " y="; print_int (widget_y main_wid);
  print_string " w="; print_int (widget_width main_wid);
  print_string " h="; print_int (widget_height main_wid);
  print_newline()

and test_popup wid_named txt _ =
  text_send_string(wid_named "T", txt ^ " ")

and autre_action xd _ =
  let ca_marche wid = message "ca marche " in
  let wid = rt_create_widget(
    xd, "glop", "glop",
    ButtonD("bouton", ca_marche)
  ) in
  rt_map_widget wid

and quit_fun wid_named _ =
  let wid = wid_named "test"
  and wid_q = wid_named "question" in
  let w = widget_width wid and h = widget_height wid
  and sw = widget_width wid_q and sh = widget_height wid_q in
  rt_move_widget(wid_q, (w-sw)quo 2, (h-sh)quo 2);
  rt_map_widget wid_q

and keyp_fun(wid, c) =
  text_send_string(wid, " \b" ^ c ^ "_\b")

and stdin_fun _ =
  let c = read std_in 1 in
  print_string "<"; print_string c; print_string ">"; flush std_out

and trace_scr val =
  print_string "scroll ";
  print_string "; val="; print_int val;
  print_newline()

and answer xa wid_named b _ =
  if b then rt_stop_main_loop xa
  else rt_unmap_widget(wid_named "question")

and popup_on_raw popup_wid (wid, but, x, y) =
  rt_map_popup_widget(popup_wid, x, y, 0)
;;

let xll xd wid = xevent_x_root xd - xevent_x xd - widget_border wid
and yll xd wid = xevent_y_root xd - xevent_y xd + widget_height wid
;;

let sub_popup xd (txt, wid, lev) =
  PackD(Horizontal, [
    PopupA [FillerAtt] (txt, fun _ -> rt_unmap_widget wid);
    PopupD (">", fun bwid ->
      let xll = xll xd bwid and yll = yll xd bwid in
      let x = xll + (widget_width bwid quo 2)
      and y = yll - (widget_height bwid quo 2) in
      rt_map_popup_widget(wid, x, y, lev)
    )
  ])

and empty_wid xd =
  rt_create_popup_widget(xd, PackD(Horizontal, []))
;;

let translate_wid xd =
  let wid_named = widget_named xd in
  let test_popup = test_popup wid_named in
  rt_create_popup_widget(xd, PackD(Vertical, [
    TitleD "Hello";
    CommD("this", test_popup "ceci");
    CommD("is", test_popup "est");
    CommD("a", test_popup "un");
    CommD("popup menu", test_popup "menu deroulant");
    CommD("", fun _ -> ());
    CommD("gag", fun _ -> select_raise(wid_named "Menu", 1))
  ]))

and gag_wid xd =
  let wid_named = widget_named xd in
  let test_popup = test_popup wid_named in
  rt_create_popup_widget(xd, PackD(Vertical, [
    PackD(Horizontal, [
      TitleD "Salut";
      CommD("Ca", test_popup "my");
      CommD("marche", test_popup "tailor");
      CommD("aussi", test_popup "is");
      CommD("horizontalement", test_popup "rich")
    ]);
    CommD("ok", fun _ -> select_raise(wid_named "Menu", 0))
  ]))

and button_wid xd =
  let wid_named = widget_named xd in
  rt_create_popup_widget(xd, CommD("bouton", action wid_named))

and machines_wid xd service_wid sun_wid workstations_wid =
  let test_popup = test_popup (widget_named xd) in
  rt_create_popup_widget(xd, PackD(Vertical, [
    sub_popup xd ("service", service_wid, 1);
    sub_popup xd ("sun", sun_wid, 1);
    sub_popup xd ("workstations", workstations_wid, 1)
  ]))

and service_wid xd =
  let test_popup = test_popup (widget_named xd) in
  rt_create_popup_widget(xd, PackD(Vertical, [
    CommD("Margaux", test_popup "Margaux");
    CommD("Pommard", test_popup "Pommard");
    CommD("Seti", test_popup "Seti");
    CommD("Nuri", test_popup "Nuri");
    CommD("Romanee", test_popup "Romanee");
    CommD("Corton", test_popup "Corton");
    CommD("Ens", test_popup "Ens")
  ]))

and sun_wid xd =
  let test_popup = test_popup (widget_named xd) in
  rt_create_popup_widget(xd, PackD(Vertical, [
    CommD("Beaune", test_popup "Beaune");
    CommD("Brouilly", test_popup "Brouilly");
    CommD("Cornas", test_popup "Cornas");
    CommD("Yquem", test_popup "Yquem")
  ]))

and workstations_wid xd algo_wid croap_wid formel_wid para_wid ens_wid =
  rt_create_popup_widget(xd, PackD(Vertical, [
    sub_popup xd ("algo", algo_wid, 2);
    sub_popup xd ("croap", croap_wid, 2);
    sub_popup xd ("formel", formel_wid, 2);
    sub_popup xd ("para", para_wid, 2);
    sub_popup xd ("ens", ens_wid, 2)
  ]))

and algo_wid xd =
  let test_popup = test_popup (widget_named xd) in
  rt_create_popup_widget(xd, PackD(Vertical, [
    CommD("Amour", test_popup "Amour");
    CommD("Bandol", test_popup "Bandol");
    CommD("Charmes", test_popup "Charmes");
    CommD("Fleurie", test_popup "Fleurie");
    CommD("Nuits", test_popup "Nuits");
    CommD("Quarts", test_popup "Quarts");
    CommD("Tokay", test_popup "Tokay")
  ]))

and croap_wid xd =
  let test_popup = test_popup (widget_named xd) in
  rt_create_popup_widget(xd, PackD(Vertical, [
    CommD("Barr", test_popup "Barr");
    CommD("Barsac", test_popup "Barsac");
    CommD("Fixin", test_popup "Fixin");
    CommD("Huaine", test_popup "Huaine");
    CommD("Marix", test_popup "Marix");
    CommD("Moulis", test_popup "Moulis");
    CommD("Muscat", test_popup "Muscat");
    CommD("Pogo", test_popup "Pogo");
    CommD("Sancerre", test_popup "Sancerre");
    CommD("Sylvaner", test_popup "Sylvaner");
    CommD("Tobago", test_popup "Tobago");
    CommD("Wallis", test_popup "Wallis");
    CommD("Zeus", test_popup "Zeus")
  ]))

and formel_wid xd =
  let wid_named = widget_named xd in
  let test_popup = test_popup wid_named in
  rt_create_popup_widget(xd, PackD(Vertical, [
    CommD("Ausone", test_popup "Ausone");
    CommD("Banyuls", test_popup "Banyuls");
    CommD("Bergerac", test_popup "Bergerac");
    CommD("Bouzy", test_popup "Bouzy");
    CommD("Jurancon", test_popup "Jurancon");
    CommD("Latour", test_popup "Latour");
    CommD("Madiran", test_popup "Madiran");
    CommD("Morgon", test_popup "Morgon");
    CommD("Musigny", test_popup "Musigny");
    CommA [
      BackgroundAtt(ColorBg(
        if is_colored xd then rt_create_color(xd, 255, 0, 0) else
        rt_white_color xd
      ))
    ] ("Peray", test_popup "Peray");
    CommD("", (fun _ -> ()));
    CommD("Pernand", test_popup "Pernand");
    CommD("Petrus", test_popup "Petrus");
    CommD("Pomerol", test_popup "Pomerol");
    CommD("Pouilly", test_popup "Pouilly");
    CommD("Quincy", test_popup "Quincy");
    CommD("Reuilly", test_popup "Reuilly");
    CommD("Riesling", test_popup "Riesling");
    CommD("Rieussec", test_popup "Rieussec");
    CommD("Santenay", test_popup "Santenay");
    CommD("Vougeot", test_popup "Vougeot")
  ]))

and para_wid xd =
  let test_popup = test_popup (widget_named xd) in
  rt_create_popup_widget(xd, PackD(Vertical, [
    CommD("Bellet", test_popup "Bellet");
    CommD("Chablis", test_popup "Chablis");
    CommD("Couchey", test_popup "Couchey");
    CommD("Givry", test_popup "Givry");
    CommD("Kpriss", test_popup "Kpriss");
    CommD("Volnay", test_popup "Volnay");
    CommD("Saumur", test_popup "Saumur")
  ]))

and ens_wid xd =
  let test_popup = test_popup (widget_named xd) in
  rt_create_popup_widget(xd, PackD(Vertical, [
    CommD("Aneth", test_popup "Aneth");
    CommD("Ares", test_popup "Ares");
    CommD("Asterix", test_popup "Asterix");
    CommD("Basilic", test_popup "Basilic");
    CommD("Berlioz", test_popup "Berlioz");
    CommD("Bouleau", test_popup "Bouleau");
    CommD("Cannelle", test_popup "Cannelle");
    CommD("Cassis", test_popup "Cassis");
    CommD("Cedre", test_popup "Cedre");
    CommD("Crocus", test_popup "Crocus");
    CommD("Debussy", test_popup "Debussy");
    CommD("Diamant", test_popup "Diamant");
    CommD("Ens", test_popup "Ens");
    CommD("Fuchsia", test_popup "Fuchsia");
    CommD("Gentiane", test_popup "Gentiane");
    CommD("Hermes", test_popup "Hermes");
    CommD("Jasmin", test_popup "Jasmin");
    CommD("Magnolia", test_popup "Magnolia");
    CommD("Menthe", test_popup "Menthe");
    CommD("Merisier", test_popup "Merisier");
    CommD("Mimosa", test_popup "Mimosa");
    CommD("Muscade", test_popup "Muscade");
    CommD("Myrtille", test_popup "Myrtille");
    CommD("Obelix", test_popup "Obelix");
    CommD("Oseille", test_popup "Oseille");
    CommD("Ravel", test_popup "Ravel");
    CommD("Rubis", test_popup "Rubis");
    CommD("Safran", test_popup "Safran");
    CommD("Saphir", test_popup "Saphir");
    CommD("Sibelius", test_popup "Sibelius");
    CommD("Verdi", test_popup "Verdi")
  ]))
;;

let rec make_test_widget xa xd translate_wid gag_wid machines_wid button_wid =
  let wid_named = widget_named xd in
  let NVIS = 10 and NSAV = 30 in
  let wid = rt_create_widget(xd, "test", "test",
    PackA [NameAtt "test"] (Horizontal, [
      SelectA [NameAtt "S"] [
        PackD(Vertical, [
          CommA [FillerAtt] ("bouton", action wid_named);
          ButtonD("pustule", autre_action xd);
          PackA [FillerAtt] (Vertical, [
            ButtonD("trans & pos", fun _ -> select_raise(wid_named "S", 3));
            ButtonD("restart", fun _ ->
              rt_destroy_widget (widget_named xd "test");
              rt_destroy_widget (widget_named xd "trans");
              let wid = make_test_widget xa xd
                translate_wid gag_wid machines_wid button_wid in
              rt_map_widget wid
            );
            ButtonD("surprise", fun _ -> select_raise(wid_named "S", 1))
          ])
        ]);
        PackD(Vertical, [
          ButtonD("next", fun _ -> select_raise(wid_named "S", 2));
          PackA [FillerAtt] (Vertical, []);
          ButtonD("resource", fun _ ->
            print_string "program : "; flush std_out;
            let program = read_line std_in in
            print_string "option : "; flush std_out;
            let option = read_line std_in in
            let val = rt_get_default(xd, program, option) in
            print_string "value = "; print_string val; print_newline()
          );
          ButtonD("return", fun _ -> select_raise(wid_named "S", 0))
        ]);
        PackD(Vertical, [
          TitleD("Scrolling text");
          ButtonD("home", fun _ -> text_home (wid_named "st"));
          ButtonD("up", fun _ ->
            let wid = wid_named "st" in
            text_shift(wid, text_shift_value wid + 1);
            scroll_set(wid_named "scr", text_shift_value wid + NVIS)
          );
          PackA [FillerAtt] (Horizontal, [
            ScrollA [NameAtt "scr"] (Vertical, 0, NSAV, NVIS,
              my_scroll_set 0 (NSAV-NVIS) NVIS (fun val ->
                let wid = wid_named "st" in
                text_shift(wid, val)
              )
            );
            TextA [NameAtt "st"] (
              NVIS, 25, NSAV, text_send_string, my_text_button xd
            )
          ]);
          ButtonD("down", fun _ ->
            let wid = wid_named "st" in
            text_shift(wid, text_shift_value wid - 1);
            scroll_set(wid_named "scr", text_shift_value wid + NVIS)
          );
          ButtonD("return", fun _ -> select_raise(wid_named "S", 1))
        ]);
        PackA [BorderAtt 0] (Vertical, [
          TitleD "trans & pos";
          ButtonD("timeout", fun _ ->
            rt_set_timeout(xa, rt_current_time xa + 1000);
            rt_set_timeout_fun(xa, fun _ ->
              let t = ftime()
              and wid = wid_named "T" in
              text_send_string(wid, "\n");
              text_send_string(wid, string_of_int t.time);
              text_send_string(wid, ".");
              let t = "00" ^ string_of_int t.millitm in
              let t = sub_string t (string_length t - 3) 3 in
              text_send_string(wid, t)
            )
          );
          ButtonD("timer", fun _ ->
            rt_set_timeout(xa, rt_current_time xa + 1000);
            rt_set_timeout_fun(xa, fun _ ->
              let t = ftime()
              and wid = wid_named "T" in
              text_send_string(wid, "\n");
              text_send_string(wid, string_of_int t.time);
              text_send_string(wid, ".");
              let t = "00" ^ string_of_int t.millitm in
              let t = sub_string t (string_length t - 3) 3 in
              text_send_string(wid, t);
              rt_set_timeout(xa, rt_current_time xa + 1000)
            )
          );
          ButtonD("stop timer", fun _ -> rt_reset_timeout xa);
          PackD(Horizontal, [
            ButtonD("trans", fun bwid ->
              let xll = xll xd bwid
              and yll = yll xd bwid in
              rt_map_transient_widget(wid_named "trans", xll, yll)
            );
            ButtonD("pos", fun _ -> rt_map_widget (wid_named "pos"));
            ButtonD("auto", fun _ -> rt_map_widget (wid_named "auto"))
          ]);
          ButtonA [HeightAtt 40] ("bouton gros", fun _ -> ());
          PackD (Horizontal, [
            ButtonA [WidthAtt 125] ("a", fun _ -> ());
            ButtonA [WidthAtt 125] ("meme taille que a", fun _ -> ())
          ]);
          ButtonA [BorderAtt 6] ("bouton a bords epais", fun _ -> ());
          ButtonA [BorderAtt 0] ("bouton sans bords", fun _ -> ());
          PackA [FillerAtt; BorderAtt 0] (Vertical, []);
          ButtonD("ok", fun _ -> select_raise(wid_named "S", 0))
        ])
      ];
      ScrollD(Vertical, 100, 150, 0, my_scroll_set 100 150 50 trace_scr);
      ScrollD(Vertical, 817, 819, 0, my_scroll_set 817 819 0 trace_scr);
      ScrollD(Vertical, 0, 100, 0, fun (wid,but,val) -> scroll_set(wid,val));
      ScrollD(Vertical, 0, 100, 0, fun (wid,but,val) ->
        scroll_set(wid,val+100)
      );
      PackD(Vertical, [
        PackD(Horizontal, [
          SelectA [NameAtt "Menu"] [
            PopupD("translate", fun bwid ->
              let xll = xll xd bwid
              and yll = yll xd bwid in
              rt_map_popup_widget(translate_wid, xll, yll, 0)
            );
            PopupD("gag", fun bwid ->
              let xll = xll xd bwid
              and yll = yll xd bwid in
              rt_map_popup_widget(gag_wid, xll, yll, 0)
            )
          ];
          PopupD("machines", fun bwid ->
            let xll = xll xd bwid
            and yll = yll xd bwid in
            rt_map_popup_widget(machines_wid, xll, yll, 0)
          );
          PopupD("bouton", fun bwid ->
            let xll = xll xd bwid
            and yll = yll xd bwid in
            rt_map_popup_widget(button_wid, xll, yll, 0)
          )
        ]);
        TextA [NameAtt "T"; FillerAtt] (
          1, 15, 0, keyp_fun, fun(wid,but,x,y) -> text_goto(wid,x,y)
        )
      ]);
      PackD(Vertical, [
        ButtonD("salut", fun _ ->
          let wid = wid_named "test" in
          rt_resize_widget(
            wid, widget_width wid + 10, widget_height wid + 10
          )
        );
        ScrollD(Horizontal, -3, 10, 3, my_scroll_set 0 10 0 trace_scr);
        PackA [FillerAtt] (Vertical, []);
        ButtonD("hello", fun _ ->
          text_send_string(wid_named "T", "ca marche\n")
        )
      ]);
      ButtonD("quit", quit_fun wid_named)
    ])
  ) in
  let twid = wid_named "st" in
  text_shift(twid, NSAV-NVIS);
  text_home twid;
  scroll_set(wid_named "scr", NSAV);
  rt_define_cursor(wid_named "T",
    rt_create_cursor(
      xd, curs_src, curs_mask, curs_width, curs_height,
      (0, 0, 255), (0, 255, 0), curs_x, curs_y
    )
  );

  let _ = rt_create_transient_widget(wid, "trans",
    PackA [NameAtt "trans"] (Horizontal, [
      TextA [FillerAtt] (
        2, 80, 0, text_send_string, my_text_button xd
      );
      ButtonD("OK", fun _ -> rt_unmap_widget (wid_named "trans"));
      ButtonD("Abort", fun _ ->
        rt_unmap_widget (wid_named "trans")
      )
    ])
  ) in
  let _ = rt_create_subwidget(wid, 0, 0,
    PackA [NameAtt "question"] (Vertical, [
      TitleD(" Are you sure ? ");
      PackD(Horizontal, [
        ButtonD("yes", answer xa wid_named true);
        ButtonD("cancel", answer xa wid_named false)
      ])
    ])
  ) in

  wid
;;

let test dname =

  rt_run dname (fun xd ->
    let xa = rt_args[xd] in

    let translate_wid = translate_wid xd
    and gag_wid = gag_wid xd
    and button_wid = button_wid xd
    and machines_wid = machines_wid xd
      (service_wid xd)
      (sun_wid xd)
      (workstations_wid xd
        (algo_wid xd)
        (croap_wid xd)
        (formel_wid xd)
        (para_wid xd)
        (ens_wid xd))
    in

    rt_select_file(xa, 0, stdin_fun);

    let _ = rt_create_located_widget(xd, "pos", "pos",
      UserPosition(40, 20),
      ButtonA [NameAtt "pos"] ("pos", rt_unmap_widget)
    )
    and _ = rt_create_located_widget(xd, "auto", "auto",
      AutoPosition,
      ButtonA [NameAtt "auto"] ("auto", rt_unmap_widget)
    ) in

    let wid = make_test_widget xa xd
      translate_wid gag_wid machines_wid button_wid in
    rt_map_widget wid;

    rt_main_loop xa
  )
;;
