(* $Id: std.ml,v 1.5 92/08/25 13:17:16 ddr Exp $ *)

#open "hashtbl";;

let except_assoc e = except_e where rec except_e = function
    [] -> []
 | (x,_ as y)::l -> if x=e then l else y::except_e l
;;
let hash_add_assoc (key,val as pair) v =
  let i = (hash key) mod (vect_length v) in
    v.(i) <- pair::v.(i)
and hash_remove_assoc key v =
  let i = (hash key) mod (vect_length v) in
    v.(i) <- except_assoc key (v.(i))
and hash_assoc key v =
  match v.((hash key) mod (vect_length v)) with
      []                    -> failwith "find"
    | [key1,val1]           -> if key=key1 then val1 else failwith "find"
    | [key1,val1;key2,val2] -> if key=key1 then val1
                               else if key=key2 then val2
                               else failwith "find"
    | L                     -> assoc key L

;;

let add_setq x s = if memq x s then s else x::s;;
exception Identity;;
let share f x = try f x with Identity -> x;;
let filter_neg p = (share filter_aux where rec filter_aux =
   fun [] ->  raise Identity
   |   (x::l) -> if p x then share filter_aux l
                 else  x:: filter_aux l)
;;
let curry f x y = f(x, y);;
let try_find f = try_find_f where rec try_find_f =
   fun [] -> failwith"try_find"
   |   (h::t) -> try f h with _ -> try_find_f t;;
let hd = function x::l -> x | _ -> failwith "hd"
and tl = function x::l -> l | _ -> failwith "tl";;

let implode_ascii l =
  let len = list_length l in
  let s = make_string len ` ` in
  let rec fill_string i = function
    x::l -> set_nth_char s i (char_of_int x); fill_string (i+1) l
  | _ -> s in
  fill_string 0 l
;;
let rec item = fun
  (a::l) i -> if i = 0 then a else item l (i-1)
| _ _ -> failwith "item";;
let do_list_i f = do_list_f
  where rec do_list_f i = function
    [] -> () | x::l -> f i x; do_list_f (succ i) l;;
