(* $Id: rtdef.mlp,v 1.8 92/10/16 15:29:42 ddr Exp $ *)

(* $Id: rt.mlh,v 1.1 92/10/16 15:31:32 ddr Exp $ *)

(*** Main functions *)

(* connection to the display *)

let rt_run = rt_main__rt_run;;
let rt_initialize = rt_main__rt_initialize;;
let rt_end = rt_main__rt_end;;

(* widgets *)

let rt_create_widget = rt_main__rt_create_widget;;
let rt_map_widget = rt_main__rt_map_widget;;
let rt_unmap_widget = rt_main__rt_unmap_widget;;
let rt_destroy_widget = rt_main__rt_destroy_widget;;
let rt_change_background = rt_main__rt_change_background;;


(* events handling *)

let rt_main_loop = rt_main__rt_main_loop;;
let rt_stop_main_loop = rt_main__rt_stop_main_loop;;
let rt_treat_one_event = rt_main__rt_treat_one_event;;
let rt_treat_pending_events = rt_main__rt_treat_pending_events;;
let rt_args = rt_main__rt_args;;
let rt_select_xdata = rt_main__rt_select_xdata;;
let rt_unselect_xdata = rt_main__rt_unselect_xdata;;
let rt_select_file = rt_main__rt_select_file;;
let rt_unselect_file = rt_main__rt_unselect_file;;
let rt_current_time = rt_main__rt_current_time;;
let rt_set_timeout = rt_main__rt_set_timeout;;
let rt_set_timeout_fun = rt_main__rt_set_timeout_fun;;
let rt_reset_timeout = rt_main__rt_reset_timeout;;

(* informations about displays *)

let rt_display_name = rt_main__rt_display_name;;
let is_colored = rt_main__is_colored;;
let screen_width = rt_main__screen_width;;
let screen_height = rt_main__screen_height;;

(* informations about widgets *)

let widget_x = rt_main__widget_x;;
let widget_y = rt_main__widget_y;;
let widget_width = rt_main__widget_width;;
let widget_height = rt_main__widget_height;;
let widget_border = rt_main__widget_border;;
let widget_named = rt_main__widget_named;;
let is_mapped = rt_main__is_mapped;;
let widget_size = rt_main__widget_size;;

(* informations about events *)

let xevent_x = rt_main__xevent_x;;
let xevent_y = rt_main__xevent_y;;
let xevent_x_root = rt_main__xevent_x_root;;
let xevent_y_root = rt_main__xevent_y_root;;
let xevent_button = rt_main__xevent_button;;

(* widget attributes *)

let BackgroundAtt = rt_main__BackgroundAtt;;
let BorderBackgAtt = rt_main__BorderBackgAtt;;
let FillerAtt = rt_main__FillerAtt;;
let NameAtt = rt_main__NameAtt;;
let WidthAtt = rt_main__WidthAtt;;
let HeightAtt = rt_main__HeightAtt;;
let BorderAtt = rt_main__BorderAtt;;

(* widget backgrounds *)

let NoneBg = rt_main__NoneBg;;
let PixmapBg = rt_main__PixmapBg;;
let ColorBg = rt_main__ColorBg;;

(* drawables *)

let WidgetDr = rt_main__WidgetDr;;
let PixmapDr = rt_main__PixmapDr;;

(* orientation *)

let Horizontal = rt_main__Horizontal;;
let Vertical = rt_main__Vertical;;


(*** Button widget *)

let ButtonD = c_button__ButtonD;;
let PopupD = c_button__PopupD;;
let CommD = c_button__CommD;;
let ButtonA = c_button__ButtonA;;
let PopupA = c_button__PopupA;;
let CommA = c_button__CommA;;

let button_border = c_button__button_border;;
let button_band = c_button__button_band;;
let button_bold = c_button__button_bold;;
let button_font = c_button__button_font;;


(*** Pack widget *)

let PackD = c_pack__PackD;;
let PackA = c_pack__PackA;;

let pack_border = c_pack__pack_border;;
let pack_band = c_pack__pack_band;;
let pack_inter = c_pack__pack_inter;;


(*** Scroll widget *)

let ScrollD = c_scroll__ScrollD;;
let ScrollA = c_scroll__ScrollA;;

let scroll_set = c_scroll__scroll_set;;
let scroll_val = c_scroll__scroll_val;;

let scroll_border = c_scroll__scroll_border;;
let scroll_width = c_scroll__scroll_width;;
let scroll_band = c_scroll__scroll_band;;


(*** Text widget *)

let TextD = c_text__TextD;;
let TextA = c_text__TextA;;

let text_send_string = c_text__text_send_string;;
let text_scroll = c_text__text_scroll;;
let text_clear = c_text__text_clear;;
let text_goto = c_text__text_goto;;
let text_current_line = c_text__text_current_line;;
let text_current_column = c_text__text_current_column;;
let text_home = c_text__text_home;;
let text_shift = c_text__text_shift;;
let text_shift_value = c_text__text_shift_value;;
let text_set_mark = c_text__text_set_mark;;
let text_get_text = c_text__text_get_text;;

let rt_get_cut_buffer = c_text__rt_get_cut_buffer;;
let rt_set_cut_buffer = c_text__rt_set_cut_buffer;;

let text_border = c_text__text_border;;
let text_band = c_text__text_band;;
let text_font = c_text__text_font;;


(*** Title widget *)

let TitleD = c_title__TitleD;;
let TitleA = c_title__TitleA;;

let title_border = c_title__title_border;;
let title_band = c_title__title_band;;
let title_font = c_title__title_font;;


(*** Select widget *)

let SelectD = c_select__SelectD;;
let SelectA = c_select__SelectA;;

let select_raise = c_select__select_raise;;


(*** Raw widget *)

type property == c_raw__property;;

let RawD = c_raw__RawD;;
let RawA = c_raw__RawA;;

let ExposePr = c_raw__ExposePr;;
let KeyPr = c_raw__KeyPr;;
let ButtonPressedPr = c_raw__ButtonPressedPr;;
let ButtonReleasedPr = c_raw__ButtonReleasedPr;;
let ButtonMotionPr = c_raw__ButtonMotionPr;;
let PointerMotionPr = c_raw__PointerMotionPr;;
let EnterWindowPr = c_raw__EnterWindowPr;;
let LeaveWindowPr = c_raw__LeaveWindowPr;;


(*** Pixmap *)

let rt_create_pixmap = pixmap__rt_create_pixmap;;
let rt_select_pixmap = pixmap__rt_select_pixmap;;


(*** Color *)

let rt_create_color = color__rt_create_color;;
let rt_change_color = color__rt_change_color;;
let rt_closest_color = color__rt_closest_color;;
let rt_black_color = color__rt_black_color;;
let rt_white_color = color__rt_white_color;;
let rt_select_color = color__rt_select_color;;
let color_pixel = color__color_pixel;;
let rt_query_color = color__rt_query_color;;


(*** Pattern *)

type pattern == pattern__pattern;;

let rt_create_pattern = pattern__rt_create_pattern;;
let rt_select_pattern = pattern__rt_select_pattern;;
let rt_select_pattern_mask = pattern__rt_select_pattern_mask;;
let rt_select_pattern_clip = pattern__rt_select_pattern_clip;;
let rt_unselect_pattern_clip = pattern__rt_unselect_pattern_clip;;


(*** Drawing *)

let rt_draw_point = draw__rt_draw_point;;
let rt_draw_line = draw__rt_draw_line;;
let rt_draw_lines = draw__rt_draw_lines;;
let rt_fill_polygon = draw__rt_fill_polygon;;
let rt_fill_rectangle = draw__rt_fill_rectangle;;
let rt_draw_rectangle = draw__rt_draw_rectangle;;
let rt_fill_arc = draw__rt_fill_arc;;
let rt_draw_arc = draw__rt_draw_arc;;
let rt_clear_widget = draw__rt_clear_widget;;
let rt_clear_area = draw__rt_clear_area;;
let rt_draw_string = draw__rt_draw_string;;
let rt_erase_draw_string = draw__rt_erase_draw_string;;
let rt_copy_area = draw__rt_copy_area;;

let rt_set_line_width = draw__rt_set_line_width;;
let rt_set_backing_store = draw__rt_set_backing_store;;


(*** Image *)

type image == image__image;;

let rt_create_image = image__rt_create_image;;
let rt_put_image = image__rt_put_image;;
let rt_get_image = image__rt_get_image;;
let rt_get_pixel = image__rt_get_pixel;;


(*** Cursor *)

let rt_create_cursor = cursor__rt_create_cursor;;
let rt_define_cursor = cursor__rt_define_cursor;;
let rt_undefine_cursor = cursor__rt_undefine_cursor;;


(*** Font *)

let rt_load_query_font = font__rt_load_query_font;;
let rt_select_font = font__rt_select_font;;
let rt_text_width = font__rt_text_width;;
let rt_font_size = font__rt_font_size;;


(*** Resource *)

let rt_get_default = resource__rt_get_default;;


(*** Miscellaneous *)

let rt_create_subwidget = misc__rt_create_subwidget;;
let rt_move_widget = misc__rt_move_widget;;
let rt_resize_widget = misc__rt_resize_widget;;
let rt_move_resize_widget = misc__rt_move_resize_widget;;
let rt_reparent_widget = misc__rt_reparent_widget;;

type position == misc__position;;

let UserPosition = misc__UserPosition;;
let AutoPosition = misc__AutoPosition;;

let rt_create_located_widget = misc__rt_create_located_widget;;

let rt_create_transient_widget = misc__rt_create_transient_widget;;
let rt_map_transient_widget = misc__rt_map_transient_widget;;
let rt_create_popup_widget = misc__rt_create_popup_widget;;
let rt_map_popup_widget = misc__rt_map_popup_widget;;

let popup_border = misc__popup_border;;

let rt_sync = misc__rt_sync;;
let rt_query_pointer = misc__rt_query_pointer;;
let rt_get_bell_params = misc__rt_get_bell_params;;
let rt_set_bell_params = misc__rt_set_bell_params;;
let rt_bell = misc__rt_bell;;


(*** User information *)

type 'a uoption == 'a uinfo__uoption;;

let UNone = uinfo__UNone;;
let user_info = uinfo__user_info;;
let rt_set_user_info = uinfo__rt_set_user_info;;
