(* $Id: pixmap.ml,v 1.4 92/07/21 16:43:32 ddr Exp $
 *
 * Rogloglo Toolkit: pixmaps
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;

let rt_create_pixmap(xd, width, height) =
  let pixmap = XCreatePixmap(
    xd.dpy, xd.rootw, width, height, xd.depth
  ) in
  {pixm_xd = xd; pixmap = pixmap}
;;

let rt_select_pixmap pix =
  let xd = pix.pixm_xd in
  XSetTile(xd.dpy, xd.gc, pix.pixmap);
  XSetFillStyle(xd.dpy, xd.gc, FillTiled)
;;
