(* $Id: pattern.ml,v 1.6 92/08/25 13:17:05 ddr Exp $)
 *
 * Rogloglo Toolkit: patterns
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;

type pattern = {
  patt_xd     : xdata;
  pattern     : Pixmap
}
;;

let rt_create_pattern(xd, data, width, height) =
  let pixm = XCreateBitmapFromData(xd.dpy, xd.rootw, data,
    width, height
  ) in
  {patt_xd = xd; pattern = pixm}  
;;

let rt_select_pattern (patt, ts_x_origin, ts_y_origin) =
  let xd = patt.patt_xd in
  XSetStipple(xd.dpy, xd.gc, patt.pattern);
  XSetFillStyle(xd.dpy, xd.gc, FillOpaqueStippled);
  XSetTSOrigin (xd.dpy, xd.gc, ts_x_origin, ts_y_origin)
;;

let rt_select_pattern_mask (patt, ts_x_origin, ts_y_origin) =
  let xd = patt.patt_xd in
  XSetStipple (xd.dpy, xd.gc, patt.pattern);
  XSetFillStyle (xd.dpy, xd.gc, FillStippled);
  XSetTSOrigin (xd.dpy, xd.gc, ts_x_origin, ts_y_origin)
;;

let rt_select_pattern_clip (patt, clip_x_origin, clip_y_origin) =
  let xd = patt.patt_xd in
  XSetClipMask (xd.dpy, xd.gc, patt.pattern);
  XSetClipOrigin (xd.dpy, xd.gc, clip_x_origin, clip_y_origin)
;;

let rt_unselect_pattern_clip xd =
  XSetClipMask (xd.dpy, xd.gc, XNone)
;;

