(* $Id: image.ml,v 1.5 92/07/26 21:03:30 ddr Exp $
 *
 * Rogloglo Toolkit: images
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;

type image = {
  ximage      : XImage;
  mlimage     : MLimage;
  im_data     : string option
}
;;

let rt_create_image(xd, data, width, height, depth) =
  let image = XCreateImageNullData (
    xd.dpy, xd.vis, depth,
    (if depth = 1 then XYBitmap else ZPixmap), 0,
    width, height, 8, 0
  ) in
  set_XImage_bitmap_bit_order(LSBFirst, image);
  set_XImage_byte_order(LSBFirst, image);
  {
    ximage = image;
    mlimage = MLimage_of_XImage image;
    im_data = Some data
  }
;;

let rt_put_image(draw, image, s_x, s_y, d_x, d_y, width, height) =
  let ximage = image.ximage and im_data = image.im_data in
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  begin match im_data with
    None ->
      XPutImage(xd.dpy, draw, xd.gc, ximage,
        s_x, s_y,
        d_x, d_y, width, height
      )
  | Some im_data ->
      XPutImageWithData(xd.dpy, draw, xd.gc, ximage, im_data,
        s_x, s_y,
        d_x, d_y, width, height
      )
  end
;;

let rt_get_image(draw, x, y, width, height) =
  let (xd, draw) = match draw with
    C'WidgetDr wid -> (wid.wid_xd, wid.win)
  | C'PixmapDr pixm -> (pixm.pixm_xd, pixm.pixmap) in
  let ximage = XGetImage (
    xd.dpy, draw, x, y, width, height,
    255, ZPixmap
  ) in
  {
    ximage = ximage;
    mlimage = MLimage_of_XImage ximage;
    im_data = None
  }
;;

let rt_get_pixel (im, x, y) =
  match im.im_data with
    None -> XGetPixel (im.ximage, x, y)
  | Some im_data -> XGetPixelWithData (im.ximage, im_data, x, y)
;;
