(* $Id: font.ml,v 1.1 92/07/28 10:46:53 ddr Exp Locker: ddr $ *)

#open "std";;
#open "xlib";;
#open "rtdef";;

let make_font xd fs mask =
  let ascent = XFontStruct_ascent fs
  and descent = XFontStruct_descent fs in
  {
    font_xd = xd;
    fs = fs;
    fid = XFontStruct_fid fs;
    gc_mask = mask;
    ascent = ascent;
    descent = descent;
    fwidth = XTextWidth(fs, "m", 1);
    fheight = ascent+descent
  }
;;

let rt_load_query_font (xd, fname) =
  try
    hash_assoc fname xd.font_by_name 
  with _ ->
    let font =
      let fs = XLoadQueryFont(xd.dpy, fname) in
      if is_null_XFontStruct fs then (
        let xid = XGContextFromGC (XDefaultGC (xd.dpy, xd.scr)) in
        let fs = XQueryFont (xd.dpy, xid) in
        xd.end_func <-
          (function () -> XFreeFontInfoSpec fs)::xd.end_func;
        make_font xd fs 0
      )
      else (
        xd.end_func <-
          (function () -> XFreeFont (xd.dpy, fs))::xd.end_func;
        make_font xd fs GCFont
      )
    in
    hash_add_assoc (fname, font) xd.font_by_name;
    font
;;

let rt_select_font font =
  let xd = font.font_xd in
  XSetFont (xd.dpy, xd.gc, font.fid)
;;

let rt_text_width (font, str) =
  XTextWidth (font.fs, str, string_length str)
;;

let rt_font_size font =
  font.fheight
;;
