(* $Id: draw.ml,v 1.9 92/08/25 13:16:59 ddr Exp $
 *
 * Rogloglo Toolkit: drawing routines
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;
#open "util";;

let rt_draw_point(draw, x, y) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XDrawPoint(xd.dpy, draw, xd.gc, x, y)

and rt_draw_line(draw, x1, y1, x2, y2) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XDrawLine(xd.dpy, draw, xd.gc, x1, y1, x2, y2)

and rt_draw_lines =
  let pts = mallocated_var (fun _ -> alloc_XPoint (20)) (ref None) in
function (draw, points) ->
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  let pts = pts() in
  do_list_i (fun i (x, y) ->
    let ii = i in
    set_XPoint_x(x, pts, ii);
    set_XPoint_y(y, pts, ii)
  ) 0 points;
  XDrawLines(xd.dpy, draw, xd.gc, pts, (list_length points),
      CoordModeOrigin)

and rt_fill_polygon =
  let pts = mallocated_var (fun _ -> alloc_XPoint (20)) (ref None) in
function (draw, points) ->
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  let pts = pts() in
  do_list_i (fun i (x, y) ->
    let ii = i in
    set_XPoint_x(x, pts, ii);
    set_XPoint_y(y, pts, ii)
  ) 0 points;
  XFillPolygon(xd.dpy, draw, xd.gc, pts, (list_length points),
      Convex, CoordModeOrigin)

and rt_fill_rectangle(draw, x, y, width, height) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XFillRectangle(xd.dpy, draw, xd.gc, x, y,
      width, height)

and rt_draw_rectangle(draw, x, y, width, height) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XDrawRectangle(xd.dpy, draw, xd.gc, x, y,
    width, height)

and rt_fill_arc (draw, x, y, width, height, a1, a2) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XFillArc(xd.dpy, draw, xd.gc, x, y,
    width, height, a1, a2)

and rt_draw_arc (draw, x, y, width, height, a1, a2) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XDrawArc(xd.dpy, draw, xd.gc, x, y,
    width, height, a1, a2)
  
and rt_clear_area(wid, x, y, width, height) =
  let xd = wid.wid_xd in
  XClearArea(xd.dpy, wid.win, x, y, width, height,
      0)

and rt_clear_widget wid =
  let xd = wid.wid_xd in
  XClearWindow(xd.dpy, wid.win)

and rt_erase_draw_string(draw, x, y, str) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XDrawImageString(xd.dpy, draw, xd.gc,
    x, y, str, (string_length(str))
  )

and rt_draw_string(draw, x, y, str) =
  let xd, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  XDrawString(xd.dpy, draw, xd.gc,
    x, y, str, (string_length(str))
  )
;;

let rt_copy_area(draw1, draw2, src_x, src_y, width, height, dst_x, dst_y) =
  let xd1, draw1 = match draw1 with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap
  and xd2, draw2 = match draw2 with
    C'WidgetDr wid -> wid.wid_xd, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xd, pixm.pixmap in
  if xd1 != xd2 then
    failwith "rt_copy_area: can't copy between different displays";
  let xd = xd1 in
  XCopyArea(xd.dpy, draw1, draw2, xd.gc, src_x, src_y,
    width, height, dst_x, dst_y)
;;

let rt_set_line_width (xd, lw) =
  XSetLineAttributes (xd.dpy, xd.gc, lw, LineSolid, (*CapButt*)CapRound, JoinMiter)
;;

let rt_set_backing_store =
  let xswa = mallocated_var alloc_XSetWindowAttributes (ref None) in
function wid ->
  let xswa = xswa() in
  set_XSetWindowAttributes_backing_store(Always, xswa);
  XChangeWindowAttributes(wid.wid_xd.dpy, wid.win, CWBackingStore, xswa)
;;
