(* $Id: cursor.ml,v 1.6 92/10/08 16:44:50 ddr Exp $ *)

#open "std";;
#open "xlib";;
#open "rtdef";;
#open "util";;

let CM = 65535;;

let make_xcolor (red_val, green_val, blue_val) xcol =
  let red_val = max 0 (min CM (256*red_val))
  and green_val = max 0 (min CM (256*green_val))
  and blue_val = max 0 (min CM (256*blue_val)) in
  set_XColor_red(red_val, xcol);
  set_XColor_green(green_val, xcol);
  set_XColor_blue(blue_val, xcol);
  set_XColor_flags(DoRed lor DoGreen lor DoBlue, xcol)
;;

let rt_create_cursor =
  let foreg_col = mallocated_var alloc_XColor (ref None)
  and backg_col = mallocated_var alloc_XColor (ref None) in
function (xd, src, mask, width, height, foreg, backg, x, y) ->
  let src_pixm = XCreateBitmapFromData(
    xd.dpy, xd.rootw, src,
    width, height
  )
  and mask_pixm = XCreateBitmapFromData(
    xd.dpy, xd.rootw, mask,
    width, height
  )
  and foreg_col = foreg_col() and backg_col = backg_col() in
  make_xcolor foreg foreg_col; make_xcolor backg backg_col;
  let cursor = XCreatePixmapCursor(
    xd.dpy, src_pixm, mask_pixm, foreg_col, backg_col,
    x, y
  )
  in
  XFreePixmap(xd.dpy, src_pixm);
  XFreePixmap(xd.dpy, mask_pixm);
  {
    curs_xd = xd;
    cursor = cursor
  }
;;

let rt_define_cursor (wid, curs) =
  let xd = wid.wid_xd in
  XDefineCursor(xd.dpy, wid.win, curs.cursor)
;;

let rt_undefine_cursor wid =
  let xd = wid.wid_xd in
  XUndefineCursor(xd.dpy, wid.win)
;;
