(* $Id: color.ml,v 1.8 92/10/08 16:44:48 ddr Exp $
 *
 * Rogloglo Toolkit: colors
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;
#open "util";;

let CM = 65535;;

let rt_change_color =
  let xcol = mallocated_var alloc_XColor (ref None) in
function (col, red_val, green_val, blue_val) ->
  let xd = col.col_xd
  and xcol = xcol() in
  set_XColor_pixel(col.pixel, xcol);
  let red_val = max 0 (min CM (256*red_val))
  and green_val = max 0 (min CM (256*green_val))
  and blue_val = max 0 (min CM (256*blue_val)) in
  set_XColor_red(red_val, xcol);
  set_XColor_green(green_val, xcol);
  set_XColor_blue(blue_val, xcol);
  set_XColor_flags(DoRed lor DoGreen lor DoBlue, xcol);
  XStoreColor(xd.dpy, xd.cmap, xcol)
;;

let rt_create_color =
  let pp = mallocated_var (fun _ -> alloc_LongRef (), alloc_LongRef ())
    (ref None) in
function (xd, red_val, green_val, blue_val) ->
  let (pixels, plane_masks) = pp() in
  if XAllocColorCells(
    xd.dpy, xd.cmap, 0, plane_masks, 0, pixels, 1
  ) = 0 then failwith "rt_create_color";
  let col = {
    col_xd = xd;
    pixel = LongRef_value pixels
  } in
  rt_change_color(col, red_val, green_val, blue_val);
  col

and rt_black_color xd =
  {col_xd = xd; pixel = xd.black}
and rt_white_color xd =
  {col_xd = xd; pixel = xd.white}
and color_pixel col = col.pixel
;;

let rt_closest_color =
  let xcol = mallocated_var alloc_XColor (ref None) in
function (xd, red_val, green_val, blue_val) ->
  let xcol = xcol () in
  let red_val = max 0 (min CM (256*red_val))
  and green_val = max 0 (min CM (256*green_val))
  and blue_val = max 0 (min CM (256*blue_val)) in
  set_XColor_red (red_val, xcol);
  set_XColor_green (green_val, xcol);
  set_XColor_blue (blue_val, xcol);
  set_XColor_flags (DoRed lor DoGreen lor DoBlue, xcol);
  let _ = XAllocColor (xd.dpy, xd.cmap, xcol) in
  {
    col_xd = xd;
    pixel = XColor_pixel xcol
  }
;;

let rt_select_color col =
  let xd = col.col_xd in
  XSetForeground(xd.dpy, xd.gc, col.pixel);
  XSetFillStyle(xd.dpy, xd.gc, FillSolid)
;;

let rt_query_color =
  let xcol = mallocated_var alloc_XColor (ref None) in
function (xd, pix) ->
  let xcol = xcol () in
  set_XColor_pixel (pix, xcol);
  set_XColor_flags (DoRed lor DoGreen lor DoBlue, xcol);
  XQueryColor (xd.dpy, xd.cmap, xcol);
  (XColor_red xcol / 256, XColor_green xcol / 256, XColor_blue xcol / 256)
;;

