(* $Id: c_select.ml,v 1.6 92/07/26 21:03:19 ddr Exp $
 *
 * Rogloglo Toolkit: select widget
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;
#open "util";;

type select_local_info = {
  widlist : widget list
}
;;

let select_local_info, get_select_local_info = dynamo_local_info
  "select_local_info" (ref (None: select_local_info option))
;;

exception incorrect;;

let select_raise(wid, n) =
  try
    let li = get_select_local_info wid.info in
    let swid = try item li.widlist n with _ -> raise incorrect in
    XRaiseWindow(wid.wid_xd.dpy, swid.win)
  with incorrect -> ()
;;

let SelectA attr slist =

  let szh = it_list (fun(w,h,b as szh) -> function
    C'WidthAtt v -> (Some v,h,b)
  | C'HeightAtt v -> (w,Some v,b)
  | C'BorderAtt v -> (w,h,Some v)
  | _ -> szh) (None,None,None) attr in

{
  wsize = (function xd ->
    let (width, height) = it_list (fun (mw, mh) wdesc ->
      let (sw, sh, sb) = wdesc.wsize xd in
      ((max mw (sw+2*sb)), (max mh (sh+2*sb)))
    ) (0, 0) slist in
    let w = max (match szh with (Some v,_,_) -> v | _ -> 1) width
    and h = max (match szh with (_,Some v,_) -> v | _ -> 1) height
    and b = match szh with (_,_,Some v) -> v | _ -> 0
    in (w,h,b)
  )
;
  wcreate = (function (xd, pwin, wdesc, x, y, width, height, border) ->
    let win = XCreateSimpleWindow(xd.dpy, pwin,
        x, y,
        (max width 1), (max height 1), (max border 0),
        xd.black, xd.white
    ) in
    let select_list = rev (it_list (fun sl wdesc ->
      let (_, _, b) = wdesc.wsize xd in
      let wid = wdesc.wcreate(
        xd, win, wdesc, 0, 0, width-2*b, height-2*b, b
      ) in wid::sl
    ) [] slist) in
    XSelectInput(xd.dpy, win, StructureNotifyMask);
    XMapSubwindows(xd.dpy, win);
    XRaiseWindow(xd.dpy, (hd select_list).win);
    let info = select_local_info {widlist = select_list} in
    add_widget attr win {
      wid_xd = xd; win = win;
      x = x; y = y; width = width; height = height; border = border;
      wdesc = wdesc; is_mapped = false;
      info = info; user_info = no_user_info;
      children = select_list
    }
  )
;
  wdestroy = (function wid ->
    remove_widget attr wid.win wid
  )
;
  wdispatch = (function (wid, xev) ->
    let t = XEvent_type xev in
    if t = ConfigureNotify then (
      let xev = XEvent_xconfigure xev in
      let width = (XConfigureEvent_width xev)
      and height = (XConfigureEvent_height xev) in
      if width <> wid.width or height <> wid.height then (
        let xd = wid.wid_xd in
        wid.width <- width; wid.height <- height;
        let li = get_select_local_info wid.info in
        do_list (fun wid ->
          let (_, _, b) = wid.wdesc.wsize xd in
          XResizeWindow(xd.dpy, wid.win,
            (max(width-2*b)1), (max(height-2*b)1)
          )
        ) li.widlist
      )
    )
  )
;
  filler = mem C'FillerAtt attr
}
;;

let SelectD = SelectA []
;;
