(* $Id: c_raw.ml,v 1.9 92/07/26 21:03:16 ddr Exp $
 *
 * Rogloglo Toolkit: raw widget class
 *)

#open "xlib";;
#open "std";;
#open "rtdef";;
#open "util";;
#uninfix "land";;

type property =
  C'ExposePr of (widget * int * int * int * int -> unit)
| C'KeyPr of (widget * string -> unit)
| C'ButtonPressedPr of (widget * int * int * int -> unit)
| C'ButtonReleasedPr of (widget -> unit)
| C'ButtonMotionPr of (widget * int * int -> unit)
| C'PointerMotionPr of (widget * int * int -> unit)
| C'EnterWindowPr of (widget -> unit)
| C'LeaveWindowPr of (widget -> unit)
;;

let ExposePr f = C'ExposePr f
and KeyPr f = C'KeyPr f
and ButtonPressedPr f = C'ButtonPressedPr f
and ButtonReleasedPr f = C'ButtonReleasedPr f
and ButtonMotionPr f = C'ButtonMotionPr f
and PointerMotionPr f = C'PointerMotionPr f
and EnterWindowPr f = C'EnterWindowPr f
and LeaveWindowPr f = C'LeaveWindowPr f
;;

exception not_ascii;;

let RawA attr (w, h, b, pl) =

  let (exp_cb, key_cb, bp_cb, br_cb, pm_cb, ew_cb, lw_cb) =
  it_list (fun(exp,key,bp,br,pm,ew,lw) -> function
    C'ExposePr exp -> (exp,key,bp,br,pm,ew,lw)
  | C'KeyPr key -> (exp,key,bp,br,pm,ew,lw)
  | C'ButtonPressedPr bp -> (exp,key,bp,br,pm,ew,lw)
  | C'ButtonReleasedPr br -> (exp,key,bp,br,pm,ew,lw)
  | C'ButtonMotionPr pm -> (exp,key,bp,br,pm,ew,lw)
  | C'PointerMotionPr pm -> (exp,key,bp,br,pm,ew,lw)
  | C'EnterWindowPr ew -> (exp,key,bp,br,pm,ew,lw)
  | C'LeaveWindowPr lw -> (exp,key,bp,br,pm,ew,lw)
  ) (ffail,ffail,ffail,ffail,ffail,ffail,ffail) pl
  and szh = it_list (fun(w,h,b as szh) -> function
    C'WidthAtt v -> (Some v,h,b)
  | C'HeightAtt v -> (w,Some v,b)
  | C'BorderAtt v -> (w,h,Some v)
  | _ -> szh) (None,None,None) attr in

{
  wsize = (function xd ->
    let w = max (match szh with (Some v,_,_) -> v | _ -> 1) w
    and h = max (match szh with (_,Some v,_) -> v | _ -> 1) h
    and b = match szh with (_,_,Some v) -> v | _ -> b
    in (w, h, b)
  )
;
  wcreate = (function (xd, pwin, wdesc, x, y, width, height, border) ->
    let smask = it_list (fun m ->
    function
      C'ExposePr _ -> m lor ExposureMask
    | C'KeyPr _ -> m lor KeyPressMask
    | C'ButtonPressedPr _ -> m lor
        (* ButtonPressMask lor OwnerGrabButtonMask lor *)
        ButtonPressMask
    | C'ButtonReleasedPr _ -> m lor ButtonReleaseMask
    | C'ButtonMotionPr _ -> m lor ButtonMotionMask
    | C'PointerMotionPr _ -> m lor PointerMotionMask
    | C'EnterWindowPr _ -> m lor EnterWindowMask
    | C'LeaveWindowPr _ -> m lor LeaveWindowMask
    ) StructureNotifyMask pl in
    let win = create_window(
      xd, pwin, x, y, width, height, border, attr, smask
    ) in
    add_widget attr win {
      wid_xd = xd; win = win;
      x = x; y = y; width = width; height = height; border = border;
      wdesc = wdesc; is_mapped = false;
      info = no_info; user_info = no_user_info;
      children = []
    }
  )
;
  wdestroy = (function wid ->
    remove_widget attr wid.win wid
  )
;
  wdispatch = (function (wid, xev) ->
    let xd = wid.wid_xd
    and t = XEvent_type xev in
    if t = Expose then (
      let xev = XEvent_xexpose xev in
      exp_cb(wid,
        (XExposeEvent_x xev),
        (XExposeEvent_y xev),
        (XExposeEvent_width xev),
        (XExposeEvent_height xev)
      )
    ) else if t = KeyPress then (
      let xev = XEvent_xkey xev in
      let state = (XKeyEvent_state xev) in
      let c = XKeycodeToKeysym(xd.dpy, XKeyEvent_keycode xev,
        (if land state ShiftMask != 0 then 1 else 0)
      ) in
      let cc =  c in
      let cc = if land state ControlMask != 0 then land cc 31 else cc in
      try
        let a =
          match cc with
            65288 | 65535 -> "\b" | 65293 -> "\n"
          | 65361 -> "Left" | 65362 -> "Up"  | 65363 -> "Right"
          | 65364 -> "Down" | 65379 -> "Ins"
          | 65456 -> "K0" | 65457 -> "K1" | 65458 -> "K2" | 65459 -> "K3"
          | 65460 -> "K4" | 65461 -> "K5" | 65462 -> "K6" | 65463 -> "K7"
          | 65464 -> "K8" | 65465 -> "K9"
          | 65496 -> "R7"  | 65498 -> "R9"  | 65500 -> "R11"
          | 65502 -> "R13" | 65504 -> "R15"
          | _ -> try make_string 1 (char_of_int cc) with _ -> raise not_ascii
        in
        key_cb(wid, a)
      with not_ascii -> ()
    )
    else if t = ButtonPress then (
      let xev = XEvent_xbutton xev in
      bp_cb(wid,
        (XButtonEvent_button xev),
        (XButtonEvent_x xev),
        (XButtonEvent_y xev)
      )
    ) else if t = ButtonRelease then (
      if xd.win_but == C'WB_None then br_cb wid
    ) else if t = MotionNotify then (
      let args = (xd.dpy, PointerMotionMask, xev) in
      while XCheckMaskEvent args <> 0 do
        ()
      done;
      let xev = XEvent_xmotion xev in
      pm_cb(wid,
        (XMotionEvent_x xev),
        (XMotionEvent_y xev)
      )
    ) else if t = EnterNotify then (
      ew_cb wid
    ) else if t = LeaveNotify then (
      lw_cb wid
    ) else if t = ConfigureNotify then (
      let xev = XEvent_xconfigure xev in
      wid.width <- (XConfigureEvent_width xev);
      wid.height <- (XConfigureEvent_height xev)
    )
  )
;
  filler = mem C'FillerAtt attr
}
;;

let RawD = RawA []
;;
