# $Id: mkstub.awk,v 1.2 92/10/08 16:45:47 ddr Exp $

BEGIN {
	cnt = -2
}

/#endif/ {
	warned = 0
	for (i = 0; i < cnt; i++) {
		if (atype[i] == "int*") ref[i] = 1
		else if (atype[i] == "unsigned int*") ref[i] = 1
		else if (atype[i] == "unsigned long*") ref[i] = 1
		else if (atype[i] == "Window*") ref[i] = 1
		else ref[i] = 0
		# heuristique pour de'tecter les tableaux... (=> fausses ref)
		if (ref[i] && !warned) {
			warned = 1
			print \
"*** Warning: heuristic to detect arrays. Please check result." > "WARN"
		}
		if (\
			ref[i] &&\
			i < cnt - 1 &&\
			(\
				aname[i+1] == "count" ||\
				substr (aname[i+1], 1, 1) == "n" &&\
				substr (aname[i+1], length(aname[i+1]), 1) ==\
					"s"\
			) &&\
			(\
				atype[i+1] == "unsigned int" ||\
				atype[i+1] == "int"\
			)\
		) ref[i] = 0
		# (fin)
		if (ref[i]) {
			atype[i] = substr (atype[i], 1, length (atype[i]) - 1)
		}
	}
	printf "\n"
	printf "value ML_%s (v)\n", name
	if (cnt == 1) printf "value v;\n"
	else printf "value *v;\n";
	printf "{\n";
	for (i = 0; i < cnt; i++) {
		if (ref[i]) {
			printf "\t%s %s;\n", atype[i], aname[i]
		}
	}
	if (rtype == "") printf "\t%s (\n", name
	else printf "\t%s r = %s (\n", rtype, name
	for (i = 0; i < cnt; i++) {
		if (ref[i]) printf "\t\t&%s", aname[i]
		else {
			printf "\t\t(%s) ", atype[i]
			if (\
				atype[i] == "const char*" ||\
				atype[i] == "char*"\
			) printf "s"
			else if (\
				atype[i] == "GC" ||\
				substr(atype[i], length(atype[i]), 1) == "*"\
			) printf "a";
			else printf "i";
			printf "ar";
			if (cnt == 1) printf " ()"
			else printf "v (%d)", i;
		}
		if (i < cnt - 1) printf ",\n"
		else printf "\n"
	}
	printf "\t);\n"
	for (i = 0; i < cnt; i++) {
		if (ref[i]) {
			printf "\tField ("
			if (cnt == 1) printf "v"
			else printf "v[%d]", i
			printf ", 0) = Val_long (%s);\n", aname[i]
		}
	}
	if (rtype == "") printf "\treturn unit;\n"
	else {
		printf "\treturn "
		if (rtype == "GC" || substr(rtype, length(rtype), 1) == "*")
			printf "Val_addr";
		else printf "Val_long";
		print " (r);";
	}
	printf "}\n"
	exit
}

cnt >= 0 {
	atype[cnt] = ""
	for (i = 1; i < NF-3; i++) atype[cnt] = atype[cnt] $i " "
	atype[cnt] = atype[cnt] $(NF-3)
	aname[cnt] = $(NF-1)
	cnt++
}

/#if/ {cnt = 0}

cnt == -1 {
	name = $(NF-1);
	rtype = "";
	for (i = 2; i < NF-2; i++) rtype = rtype $i " ";
	if (NF > 3) rtype = rtype $(NF-2);
}

cnt == -2 {
	printf "/* text generated automatically by mkstub */\n";
	printf "\n";
	printf "#include \"stub.h\"\n";
	if ($0 == "Xutil.h") printf "#include <X11/%s>\n", $0;
	cnt = -1;
}
