# $Id: mkint.awk,v 1.1 92/10/08 10:55:00 ddr Exp Locker: ddr $

BEGIN {
	cnt = -1
}

/#endif/ {
	warned = 0
	for (i = 0; i < cnt; i++) {
		if (atype[i] == "int*") ref[i] = 1
		else if (atype[i] == "unsigned int*") ref[i] = 1
		else if (atype[i] == "unsigned long*") ref[i] = 1
		else if (atype[i] == "Window*") ref[i] = 1
		else ref[i] = 0
		# heuristique pour de'tecter les tableaux... (=> fausses ref)
		if (ref[i] && !warned) {
			warned = 1
			print \
"*** Warning: heuristic to detect arrays. Please check result." > "WARN"
		}
		if (\
			ref[i] &&\
			i < cnt - 1 &&\
			(\
				aname[i+1] == "count" ||\
				substr (aname[i+1], 1, 1) == "n" &&\
				substr (aname[i+1], length(aname[i+1]), 1) ==\
					"s"\
			) &&\
			(\
				atype[i+1] == "unsigned int" ||\
				atype[i+1] == "int"\
			)\
		) ref[i] = 0
		# (fin)
		if (ref[i]) {
			atype[i] = substr (atype[i], 1, length (atype[i]) - 1)
		}
		if (atype[i] == "const char*") atype[i] = "string";
		else if (atype[i] == "char*") atype[i] = "string";
		else if (atype[i] == "int*") atype[i] = "IntRef";
		else if (atype[i] == "unsigned int*") atype[i] = "IntRef";
		else if (atype[i] == "unsigned long*") atype[i] = "LongRef";
		else if (atype[i] == "Window*") atype[i] = "WindowRef"
		else if (substr (atype[i], length(atype[i]), 1) == "*")
			atype[i] = substr (\
				atype[i], 0, length(atype[i]) - 1\
			)
		else if (atype[i] == "unsigned int") atype[i] = "int";
		else if (atype[i] == "unsigned long") atype[i] = "int";
	}
	if (rtype == "char *") rtype = "C_String";
	else if (rtype == "") rtype = "unit";
	else if (substr (rtype, length (rtype)-1, 2) == " *")
		rtype = substr (rtype, 0, length (rtype) - 2)
	else if (rtype == "Bool") rtype = "int";
	printf "value %s : ", name
	for (i = 0; i < cnt; i++) {
		printf "%s ", atype[i]
		if (ref[i]) printf "ref "
		if (i < cnt - 1) printf "* "
	}
	printf "-> "
	if (rtype == "") printf "unit"
	else printf rtype
	printf " = 1 \"ML_%s\";;\n", name
	exit
}

cnt >= 0 {
	atype[cnt] = ""
	for (i = 1; i < NF-3; i++) atype[cnt] = atype[cnt] $i " "
	atype[cnt] = atype[cnt] $(NF-3)
	aname[cnt] = $(NF-1)
	cnt++
}

/#if/ {cnt = 0}

cnt < 0 {
	name = $(NF-1);
	rtype = "";
	for (i = 2; i < NF-2; i++) rtype = rtype $i " ";
	if (NF > 3) rtype = rtype $(NF-2);
}
