(* $Id: xserver.ml,v 1.1 91/06/12 18:40:24 ddr Exp $
 *
 * $Log:	xserver.ml,v $
 * Revision 1.1  91/06/12  18:40:24  ddr
 * Initial revision
 * 
 * Revision 7.3  91/05/28  20:38:44  ddr
 * - mise a jour
 * 
 * Revision 7.2  91/05/24  20:23:32  ddr
 * - version qui marche
 * 
 * Revision 7.1  91/05/23  18:44:21  ddr
 * - sauvegarde version
 * 
 *)

module xserver using
  (* from x part *)
  value xdriver : string -> num ->
    (string -> num) * (string -> num -> unit) *
    (unit -> unit) * (num -> (unit -> unit) -> unit);

  type file_desc;
  value socket_server : num -> file_desc;
  value file_close : file_desc -> unit;
  value file_number : file_desc -> num;
  value file_read : file_desc -> string -> num;
  value file_write : file_desc -> string -> num -> num;
;

#+(caml_version = "V2-6.1")
let make_string_c = make_string
;;

#-(caml_version = "V2-6.1")
let make_string_c n s = make_string n (char_of_string s)
;;

exception eof;;

let buff = make_string_c 500 " ";;

let fd_fun xwrite s _ =
  let len = file_read s buff in
  if len = 0 then raise eof else xwrite buff len
;;

let xserver dname port =
  let xread, xwrite, xclose, xselect_fd = xdriver dname 0 in (try
    message "ready...";
    let s = socket_server port in (try
      xselect_fd (file_number s) (fd_fun xwrite s);
      while true do
        let len = xread buff in
        file_write s buff len
      done
    with eof -> () | _ -> file_close s reraise);
    file_close s
  with _ -> xclose() reraise);
  xclose()
;;

end module with
  value xserver;
;
