(* $Id: xclient.ml,v 1.1 91/06/12 18:40:21 ddr Exp $
 *
 * $Log:	xclient.ml,v $
 * Revision 1.1  91/06/12  18:40:21  ddr
 * Initial revision
 * 
 * Revision 7.3  91/05/28  20:38:43  ddr
 * - mise a jour
 * 
 * Revision 7.2  91/05/24  20:23:31  ddr
 * - version qui marche
 * 
 * Revision 7.1  91/05/23  18:44:19  ddr
 * - sauvegarde version
 * 
 *)

module xclient using
  type file_desc;
  value socket_client : string -> num -> file_desc;
  value file_read : file_desc -> string -> num;
  value file_write : file_desc -> string -> num -> num;
  value file_close : file_desc -> unit;
;

let xread =
  file_read
;;

let xwrite xi buff len =
  file_write xi buff len;
  ()
;;

let xclose xi _ =
  file_close xi
;;

let xselect_fd xi _ _ =
  message "<W> no select"
;;

let xdriver machine port =
  let xi = socket_client machine port in
  xread xi, xwrite xi, xclose xi, xselect_fd xi
;;

end module with
  value xdriver;
;
