(* $Id: card_pix.ml,v 1.2 91/06/29 17:06:07 ddr Exp $
 *
 * Pixmap management
 *)

#open "rt";;

type 'a option = None | Some of 'a;;
let make_string_c n s = make_string n (nth_char s 0)
and explode_ascii s =
  let len = string_length s in explode_rec 0
  where rec explode_rec i =
    if i = len then [] else (int_of_char(nth_char s i))::explode_rec(succ i)
;;
let iterate f = iterate_f
  where rec iterate_f n x =
    if n > 0 then iterate_f (pred n) (f x)
;;
let words s =
  let len = string_length s in words_rec None 0
  where rec words_rec w i =
    if i = len then match w with
      None -> []
    | Some w -> [w]
    else let c = nth_char s i in
      if c = ` ` then match w with
        None -> words_rec None (succ i)
      | Some w -> w::words_rec None (succ i)
      else match w with
        None -> words_rec (Some (make_string 1 c)) (succ i)
      | Some w -> words_rec (Some (w^(make_string 1 c))) (succ i)
;;
let line_buff = create_string 200;;
let input_line ic = sub_string line_buff 0 (input_rec 0)
  where rec input_rec i =
    match (input_char ic) with
      `\n` -> i
    | c -> set_nth_char line_buff i c; input_rec (succ i)
;;
let buf_input ic str len = input ic str 0 len
;;

let rec item = fun
  (a::l) i -> if i = 0 then a else item l (i-1) | _ _ -> failwith "item"
;;
let vector = make_vect
and print_flush() = flush std_out
;;

let WID = 47 and HEI = 67
and NLIN = 8 and NCOL = 8
;;

let PIX_SZ = WID*HEI*NCOL
;;

let num_of_hex_string s =
  it_list (fun n c ->
    let v = match c with
      48 -> 0 | 49 -> 1 | 50 -> 2 | 51 -> 3 | 52 -> 4
    | 53 -> 5 | 54 -> 6 | 55 -> 7 | 56 -> 8 | 57 -> 9
    | 65 -> 10 | 66 -> 11 | 67 -> 12 | 68 -> 13 | 69 -> 14 | 70 -> 15
    | _ -> failwith "num_of_hex_string" in
    n*16+v
  ) 0 (explode_ascii s)
;;

let coltab fname =
  (* lecture table des couleurs *)
  let coltab = make_vect 256 (0, 0, 0) in
  let ic = open_in fname in (try
    for i = 0 to vect_length coltab - 1 do
      let str = words (input_line ic) in
      coltab.(i) <-
      (
        num_of_hex_string (item str 0),
        num_of_hex_string (item str 1),
        num_of_hex_string (item str 2)
      )
    done
  with x -> close_in ic; raise x);
  close_in ic;
  coltab
;;

let i = ref 0;;
let str = make_string_c PIX_SZ " ";;
let update_pixmap convtab update_convtab =
  i := 0;
  while !i < PIX_SZ do
    let v = convtab.(int_of_char(fstring__nth_char str !i)) in
    fstring__set_nth_char str !i (
      if v = `\000` then update_convtab (int_of_char(fstring__nth_char str !i))
      else v
    );
    incr i
  done
;;

let fill_fun = [|
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    rt_put_image(PixmapDr tower_pixmap.(0), im, 0, 0, 0, 0, WID, HEI);
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(0).(13-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 6 1
  );
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(0).(6-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 7 0
  );
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    rt_put_image(PixmapDr tower_pixmap.(1), im, 0, 0, 0, 0, WID, HEI);
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(1).(13-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 6 1
  );
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(1).(6-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 7 0
  );
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    rt_put_image(PixmapDr tower_pixmap.(2), im, 0, 0, 0, 0, WID, HEI);
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(2).(13-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 6 1
  );
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(2).(6-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 7 0
  );
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    rt_put_image(PixmapDr tower_pixmap.(3), im, 0, 0, 0, 0, WID, HEI);
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(3).(13-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 6 1
  );
  (fun im card_pixmap tower_pixmap buff_pixmap ->
    iterate (fun i ->
      rt_put_image(
        PixmapDr card_pixmap.(3).(6-i), im, i*WID, 0, 0, 0, WID, HEI
      );
      i+1
    ) 7 0;
    rt_put_image(PixmapDr buff_pixmap, im, (NCOL-1)*WID, 0, 0, 0, WID, HEI)
  )
|]
;;

let make_pixmap xd tabfile pixfile =
  let convtab = vector 256 `\000` in
  let coltab = coltab tabfile in
  let buff_pixmap = rt_create_pixmap(xd, WID, HEI) in
  let card_pixmap = vector 4 [| |] in
  for i = 0 to vect_length card_pixmap - 1 do
    let v = vector 13 buff_pixmap in
    for i = 0 to vect_length v - 1 do
      v.(i) <- rt_create_pixmap(xd, WID, HEI)
    done;
    card_pixmap.(i) <- v
  done;
  let tower_pixmap = vector 4 buff_pixmap in
  for i = 0 to vect_length tower_pixmap - 1 do
    tower_pixmap.(i) <- rt_create_pixmap(xd, WID, HEI)
  done;
  let im = rt_create_image(xd, str, NCOL*WID, HEI, 8) in

  print_string "Loading pixmap"; print_flush();
  let ic = open_in pixfile in (try
    iterate (fun i ->
      let _ = buf_input ic str PIX_SZ in
      update_pixmap convtab (fun c ->
        let (r, g, b) = coltab.(c) in
        let (r, g, b) = (r/255, g/255, b/255) in
        let col = rt_create_color(xd, r, g, b) in
        let p = char_of_int(color_pixel col) in
        convtab.(c) <- p;
        p
      );
      fill_fun.(i) im card_pixmap tower_pixmap buff_pixmap;
      print_string "."; print_flush();
      i+1
    ) NLIN 0;
    print_string " Done"; print_newline();
    (try close_in ic with _ -> ())
  with x -> close_in ic; raise x);

  card_pixmap, tower_pixmap, buff_pixmap
;;
