#open "xlib";;

let xev = alloc_XEvent ();;
let xsh = alloc_XSizeHints ();;

let make_win dpy wname width height =
  let root = XDefaultRootWindow dpy
  and scr = XDefaultScreen dpy in
    let win = XCreateSimpleWindow (
      dpy, root,
      100, 100, width, height, 20,
      XBlackPixel (dpy, scr),
      XWhitePixel (dpy, scr)
    ) in
      set_XSizeHints_x (100, xsh);
      set_XSizeHints_y (100, xsh);
      set_XSizeHints_width (width, xsh);
      set_XSizeHints_height (height, xsh);
      set_XSizeHints_flags (USPosition lor USSize, xsh);
      XSetStandardProperties (
        dpy, win, wname, "the_icon",
        XNone, "the_argv", xsh
      );
      XSetClassHint (dpy, win, "the_res_name", "the_res_class");
      XSelectInput (dpy, win, EnterWindowMask);
      win
;;

let test () =
  let dpy = XOpenDisplay "" in
    begin try
      let win = make_win dpy "the_main" 300 100 in
        XMapWindow (dpy, win);
        XNextEvent (dpy, xev);
        XMoveWindow (dpy, win, 200, 200);
        set_XSizeHints_x (200, xsh);
        set_XSizeHints_y (200, xsh);
        set_XSizeHints_width (50, xsh);
        set_XSizeHints_height (70, xsh);
        set_XSizeHints_flags (USPosition lor USSize, xsh);
        XSetNormalHints (dpy, win, xsh);
        XNextEvent (dpy, xev)
    with ex ->
      XCloseDisplay dpy;
      raise ex
    end;
    XCloseDisplay dpy
;;
