#open "rt/rt";;
#open "rt/c_pack";;
#open "rt/c_button";;
#open "rt/misc";;

let map_popup xd popup_wid button_wid =
  let x = xevent_x_root xd - xevent_x xd
    - widget_border button_wid
  and y = xevent_y_root xd - xevent_y xd
    + widget_height button_wid in
  rt_map_popup_widget(popup_wid, x, y, 0)
;;

let example() =
  rt_run "" (fun xd ->
    let xargs = rt_args[xd] in
    let file_popup = rt_create_popup_widget(xd,
      PackD(Vertical, [
        CommD("open", fun _ -> prerr_endline "open");
        CommD("close", fun _ -> prerr_endline "close");
        CommD("quit", fun _ -> rt_stop_main_loop xargs)
      ])
    )
    and game_popup = rt_create_popup_widget(xd,
      PackD(Vertical, [
        CommD("new game", fun _ -> prerr_endline "new game");
        CommD("abort", fun _ -> prerr_endline "abort")
      ])
    ) in
    let wid = rt_create_widget(xd, "my_title", "my_icon",
      PackD(Horizontal, [
        PopupD ("file", map_popup xd file_popup);
        PopupD ("game", map_popup xd game_popup)
      ])
    ) in
    rt_map_widget wid;
    rt_main_loop xargs
  )
;;
