/* 
 *  FUNCTION      extern void  p_generic_package(start, next)
 *  
 *  PURPOSE       To apply all the possibly successful rule packages 
 *                to the output of r_generic_rule().
 *  
 *  INPUT         LEXENTRY  *start, *next    -    the current sentence start
 *                and (evaluated) next word.
 *  
 *  OUTPUT        none
 *  
 *  SIDE EFFECTS  The control flow is altered (heh), as is the given start.
 * 
 *  CHILDREN      r_another_generic_rule()
 *                r_yet_another_generic_rule()
 * 	          .
 * 	          .
 * 	          .
 * 	          r_still_another_generic_rule()
 */

extern void
  p_generic_package(start, next)
LEXENTRY    *start, *next;
{
  int  index, failed = 0;
  
#ifdef 0
    
  for (index = 1; index < history[curr_deriv].rules[0]; index++)
	{
	  if (history[curr_deriv].rules[index] == ANOTHER_GENERIC_RULE)
	    failed = 1;
	}
  if (!failed)  
    /* 
     * this rule hasn't yet failed from this point in
     * derivation-package space 
     */
    {
      r_another_generic_rule(start, next);
      if (history[curr_deriv].rules[history[curr_deriv].rules[0]] == 
	  ANOTHER_GENERIC_RULE) 
	/* the rule has suceeded, and control will be passed to its package */
	return;
      else
	fprintf(stderr, "Rule package 'generic package' throws out rule 'another generic rule'.\n");
    }
  
  failed = 0;

  for (index = 1; index < history[curr_deriv].rules[0]; index++)
	{
	  if (history[curr_deriv].rules[index] == YET_ANOTHER_GENERIC_RULE)
	    failed = 1;
	}
  if (!failed)  
    /*
     * this rule hasn't yet failed from this point in
     * derivation-package space 
     */
    {
      r_yet_another_generic_rule(start, next);
      index = history[curr_deriv].rules[0];
      if (history[curr_deriv].rules[index] == YET_ANOTHER_GENERIC_RULE) 
	/* the rule has suceeded, and control will be passed to its package */
	return;
      else
	fprintf(stderr, "Rule package 'generic package' throws out rule 'yet another generic rule'.\n");
    }
  
  /* ... etc. */
	
  failed = 0;

  for (index = 1; index < history[curr_deriv].rules[0]; index++)
	{
	  if (history[curr_deriv].rules[index] == STILL_ANOTHER_GENERIC_RULE)
	    failed = 1;
	}
  if (!failed)  
    /* 
     * this rule hasn't yet failed from this point in
     * derivation-package space 
     */
    {
      r_still_another_generic_rule(start, next);
      index = history[curr_deriv].rules[0];
      if (history[curr_deriv].rules[index] == STILL_ANOTHER_GENERIC_RULE) 
	/* the rule has suceeded, and control will be passed to its package */
	return;
      else
	{
	  fprintf(stderr, "Rule package 'generic package' throws out rule 'still another generic rule'.\n");
	  printf("rule package 'generic package' has failed. You tried to follow the <type> phrase '%s' with '%s', which is ungrammatical.\n", start->surface, next->surface);
	  curr_condition = INVALID;
	}
    }

#endif

  /* package is not yet operational */
  strcpy(error, "rule package 'generic package' has failed. You tried to follow the <type> phrase '");
  strcat(error, start->surface);
  strcat(error, "' with '");
  strcat(error, next->surface);
  strcat(error, "' which is ungrammatical, since the package has no branches.\n");
  curr_condition = INVALID;
  
} /* end: extern void  p_generic_package(LEXENTRY *start, *next): f template */
