/*  UTILS.PL  */
/*  Shelved on the 20th April, 1988.  */


/*  This file defines several predicates:


    (1) append( List1+, List2+, List3- ),
        head( List+, Head-) and tail( List1+, List2- ).

        There's nothing special about these,  except that append is used
        in concat, below.


    (2) concat( A+, B+, S- ) and concat( L+, S- ).

        concat(A,B,S) takes two atoms, and joins them to make a third:
        i.e. concat( am, using, amusing ).

        concat(L,S) takes a list of atoms, and joins all elements in the
        list:
        i.e. concat( [ a, bc, efg ], abcefg ).

        The definitions below are portable, but slow. You may be able to
        make faster ones: an example (commented out) in Poplog is given.
        However,   concat  is   only   used  to   build  filenames,   in
        SHELL.PL, so speed is hardly crucial.

        Note that  concat has nothing directly  to do with  the Prolog-2
        problems  below, but  you can  probably implement  it faster  in
        Prolog-2.


    (3) string( S+ ).

        This succeeds if S is a list.

        It's  used  to  help  in converting  Linger  to  Expert  Systems
        International Prolog-2. In this non-standard dialect, there is a
        new datatype "string" which is a sort of character array. Linger
        was originally  implemented in Prolog-2: I've  converted it back
        to standard  Prolog for inclusion  in the library.  The Prolog-2
        version  used strings  to hold  character arrays,  and used  the
        predicate string/1 to test for  them. To make re-conversion back
        easier, I've made it use lists instead of strings; but I've kept
        calls to string/1.

        To  convert back  to  Prolog-2, just  remove  the definition  of
        string/1 below. It's built into Prolog-2.


    (4) list(X,Y).

        This is here for the same  reason as string/1. In Prolog-2, it's
        a built-in predicate which converts between lists and strings.

        To convert back to Prolog-2, remove the definition below.


        See also NAME.PL

                                Jocelyn Paine.
*/




append([],List,List).

append([H1|T1],List2,[H1|T3]) :-
    !,
    append(T1,List2,T3).


head([H|T],H).


tail([H|T],T).


concat( A, B, C ) :-
    name( A, AL ),
    name( B, BL ),
    append( AL, BL, CL ),
    name( C, CL ).


concat( [], '' ) :- !.

concat( [H], H ) :- !.

concat( [H|T], A ) :-
    concat( T, TA ),
    concat( H, TA, A ), !.


/*POPLOG
Sample fast (but non-portable) definition of concat, using Poplog:
:- prolog_language( pop11 ).


define packprologitems( list );
    packitem( maplist( list, prolog_full_deref ) );
enddefine;

:- prolog_language( prolog ).


concat( A, B, C ) :-
    prolog_eval( packprologitems( quote([A, B]) ), C ).


concat( L, C ) :-
    prolog_eval( packprologitems( quote(L) ), C ).
End sample fast definition of concat.
POPLOG*/               


string([]) :- !.
string([_|_]) :- !.


list(X,X).
