/*  FRENCH  GRAMMAR  */ 
/*  17 . 3 . 86 .  */ 
 
sentence(formed(sentence,[MC])) --> main_clause(MC).
sentence(formed(sentence,[MC,SC])) --> main_clause(MC) , sub_clause(SC).

main_clause(formed(main_clause,[N,V])) --> subj_phr(N) , verb_phr(V). 

sub_clause(formed(sub_clause,[RS,V])) --> relative_subject(RS) , verb_phr(V). 
sub_clause(formed(sub_clause,[RO,S,V])) --> relative_object(RO) , subj_phr(S) , verb_phr(V). 
 
subj_phr(formed(subj_phr,[S])) --> noun_pron_phr(S). 
 
verb_phr(formed(verb_phr,[V,P,I])) --> pos_or_neg_verb_cons(V) , verb_preposition(P) , infinitive_phr(I). 
verb_phr(formed(verb_phr,[V,A,DO,IO])) --> pos_or_neg_verb_cons(V) , adverb(A) , dir_obj_phr(DO) , indir_obj_phr(IO). 
verb_phr(formed(verb_phr,[V,DO,IO])) --> pos_or_neg_verb_cons(V) , dir_obj_phr(DO) , indir_obj_phr(IO). 
verb_phr(formed(verb_phr,[AV,C])) --> pos_or_neg_aux_verb_cons(AV) , compliment_phr(C).
 
noun_pron_phr(formed(noun_pron_phr,[N])) --> noun_phr(N). 
noun_pron_phr(formed(noun_pron_phr,[P])) --> pronoun(P). 
 
pos_or_neg_verb_cons(formed(pos_or_neg_verb_cons,[V])) --> pos_verb_cons(V). 
pos_or_neg_verb_cons(formed(pos_or_neg_verb_cons,[V])) --> neg_verb_cons(V). 

verb_preposition(formed(verb_preposition,[P])) --> preposition(P).
verb_preposition(formed(verb_preposition,[])) --> [].

infinitive_phr(formed(infinitive_phr,[RP,I])) --> rp_pron_list(RP) , infinitive(I).
infinitive_phr(formed(infinitive_phr,[NB,NE,RP,I])) --> neg_begin(NB) , neg_end(NE) , rp_pron_list(RP) , infinitive(I).
 
dir_obj_phr(formed(dir_obj_phr,[DO])) --> noun_phr(DO). 
dir_obj_phr(formed(dir_obj_phr,[])) --> [].
 
indir_obj_phr(formed(indir_obj_phr,[P,IO])) --> preposition(P) ,  noun_phr(IO). 
indir_obj_phr(formed(indir_obj_phr,[])) --> [].
 
pos_or_neg_aux_verb_cons(formed(pos_or_neg_aux_verb_cons,[formed(governing_verb,[V])])) --> aux_verb(V).
pos_or_neg_aux_verb_cons(formed(pos_or_neg_aux_verb_cons,[NB,formed(governing_verb,[V]),NE])) --> neg_begin(NB) , aux_verb(V) , neg_end(NE). 

compliment_phr(formed(compliment_phr,[C])) --> adjective(C).
 
noun_phr(formed(noun_phr,[D,A1,N,A2])) --> determiner(D) , adj_list(A1) , noun(N) , adj_list(A2). 

pos_verb_cons(formed(pos_verb_cons,[PL,A,formed(governing_verb,[PP])])) --> rp_pron_list(PL) ,  aux_verb(A) , past_participle(PP). 
pos_verb_cons(formed(pos_verb_cons,[PL,formed(governing_verb,[V])])) --> rp_pron_list(PL) ,  verb_or_aux_verb(V). 
 
neg_verb_cons(formed(neg_verb_cons,[NB,PR,A,NE,formed(governing_verb,[PP])])) --> neg_begin(NB) , rp_pron_list(PR) , aux_verb(A) , neg_end(NE) , past_participle(PP). 
neg_verb_cons(formed(neg_verb_cons,[NB,PR,formed(governing_verb,[V]),NE])) --> neg_begin(NB) , rp_pron_list(PR) , verb_or_aux_verb(V) , neg_end(NE). 
 
adj_list(formed(adj_list,[A1,A2])) --> adjective(A1) , adj_list(A2). 
adj_list(formed(adj_list,[])) -->  []. 
 
rp_pron_list(formed(rp_pron_list,[RP,PL])) --> reflexive_pronoun(RP) , pron_list(PL). 
rp_pron_list(formed(rp_pron_list,[PL])) --> pron_list(PL). 

pron_list(formed(pron_list,[PL])) --> pron_list2(PL). 
 
pron_list2(formed(pron_list2,[P,PL])) --> pronoun(P) , pron_list2(PL). 
pron_list2(formed(pron_list2,[])) --> []. 

verb_or_aux_verb(formed(verb_or_aux_verb,[V])) --> verb(V). 
verb_or_aux_verb(formed(verb_or_aux_verb,[AV])) --> aux_verb(AV). 

relative_object(formed(relative_object,[R])) --> relative_object_que(R). 
relative_object(formed(relative_object,[R])) --> relative_object_si(R). 
 
adjective(formed(adjective,[A,Pos])) --> it_is(adjective,A,Pos). 
 
adverb(formed(adverb,[A,Pos])) --> it_is(adverb,A,Pos). 
 
aux_verb(formed(aux_verb,[AV,Pos])) --> it_is(aux_verb,AV,Pos). 
 
determiner(formed(determiner,[D,Pos])) --> it_is(determiner,D,Pos). 
 
infinitive(formed(infinitive,[I,Pos])) --> it_is(infinitive,I,Pos). 

neg_begin(formed(neg_begin,[NB,Pos])) --> it_is(neg_begin,NB,Pos). 
 
neg_end(formed(neg_end,[NE,Pos])) --> it_is(neg_end,NE,Pos). 

noun(formed(noun,[N,Pos])) --> it_is(noun,N,Pos). 
 
past_participle(formed(past_participle,[PP,Pos])) --> it_is(past_participle,PP,Pos). 
 
preposition(formed(preposition,[P,Pos])) --> it_is(preposition,P,Pos). 

pronoun(formed(pronoun,[P,Pos])) --> it_is(pronoun,P,Pos). 
 
reflexive_pronoun(formed(reflexive_pronoun,[RP,Pos])) --> it_is(reflexive_pronoun,RP,Pos). 

relative_object_que(formed(relative_object_que,[R,Pos])) --> it_is(relative_object_que,R,Pos).

relative_object_si(formed(relative_object_si,[R,Pos])) --> it_is(relative_object_si,R,Pos).

relative_subject(formed(relative_subject,[R,Pos])) --> it_is(relative_subject,R,Pos).
 
verb(formed(verb,[NV,Pos])) --> it_is(verb,NV,Pos). 
 
/*  ---------------------------------------------------------------------  */

                            /*  CHECKS  */

check([noun],
      noun_phr,
      [],
      select_on_first([plurality(p)])
     ). 
check([pronoun],
      subj_phr,
      [],
      should_be([case(nom)])
     ). 
check([pronoun],
      verb_phr,
      [],
      should_not_be([case(nom)])
     ). 
check([determiner,adjective],
      noun_phr,
      [],
      concord([gender,plurality],noun,[])
     ). 
check([verb,aux_verb,reflexive_pronoun],
      main_clause,
      [],
      concord([person,plurality],subj_phr(noun),[])
     ). 
check([verb,aux_verb,reflexive_pronoun],
      sub_clause,
      [],
      concord([person,plurality],subj_phr(noun),[])
     ). 
check([sub_clause(verb),sub_clause(aux_verb),sub_clause(reflexive_pronoun)],
      sentence,
      [exists(relative_subject)],
      concord([person,plurality],main_clause(dir_obj_phr(noun)),[])
     ). 
check([verb,aux_verb,reflexive_pronoun],
      main_clause,
      [],
      concord([person,plurality],subj_phr(pronoun),[])
     ). 
check([verb,aux_verb,reflexive_pronoun],
      sub_clause,
      [],
      concord([person,plurality],subj_phr(pronoun),[])
     ). 
check([sub_clause(verb),sub_clause(aux_verb),sub_clause(reflexive_pronoun)],
      sentence,
      [exists(relative_subject)],
      concord([person,plurality],main_clause(pron_list(pronoun)),[attribute(case(acc))])
     ). 
check([verb,aux_verb],
      sentence,
      [],
      select_on_first([tense(present)])
     ). 
check([pronoun],
      verb_phr,
      [exists(dir_obj_phr)],
      should_not_be([case(acc)])
     ). 
check([pronoun],
      verb_phr,
      [exists(indir_obj_phr)],
      should_not_be([case(dat)])
     ). 
check([pronoun],
      verb_phr,
      [empty(dir_obj_phr),empty(indir_obj_phr)],
      select_on_first([case(acc)])
     ). 
check([pronoun],
      pron_list,
      [],
      select_on_first([plurality(s),gender(m)])
     ). 
check([past_participle],
      main_clause,
      [attribute(conjug_with(e4tre),past_participle)],
      concord([gender,plurality],subj_phr(noun),[])
     ). 
check([past_participle],
      sub_clause,
      [attribute(conjug_with(e4tre),past_participle)],
      concord([gender,plurality],subj_phr(noun),[])
     ). 
check([sub_clause(past_participle)],
      sentence,
      [exists(relative_subject),attribute(conjug_with(e4tre),sub_clause(past_participle))],
      concord([gender,plurality],main_clause(dir_obj_phr(noun)),[])
     ). 
check([past_participle],
      main_clause,
      [attribute(conjug_with(e4tre),past_participle)],
      concord([gender,plurality],subj_phr(pronoun),[])
     ). 
check([past_participle],
      sub_clause,
      [attribute(conjug_with(e4tre),past_participle)],
      concord([gender,plurality],subj_phr(pronoun),[])
     ). 
check([sub_clause(past_participle)],
      sentence,
      [exists(relative_subject),attribute(conjug_with(e4tre),sub_clause(past_participle))],
      concord([gender,plurality],main_clause(pron_list(pronoun)),[attribute(case(acc))])
     ). 
check([past_participle],
      main_clause,
      [exists(reflexive_pronoun),empty(dir_obj_phr),not_attribute(case(acc),pron_list(pronoun))],
      concord([gender,plurality],subj_phr(noun),[])
     ). 
check([past_participle],
      sub_clause,
      [exists(reflexive_pronoun),empty(dir_obj_phr),not_attribute(case(acc),pron_list(pronoun))],
      concord([gender,plurality],subj_phr(noun),[])
     ). 
check([sub_clause(past_participle)],
      sentence,
      [exists(relative_subject),exists(sub_clause(reflexive_pronoun)),empty(sub_clause(dir_obj_phr)),not_attribute(case(acc),sub_clause(pron_list(pronoun)))],
      concord([gender,plurality],main_clause(dir_obj_phr(noun)),[])
     ). 
check([past_participle],
      main_clause,
      [exists(reflexive_pronoun),empty(dir_obj_phr),not_attribute(case(acc),pron_list(pronoun))],
      concord([gender,plurality],subj_phr(pronoun),[])
     ). 
check([past_participle],
      sub_clause,
      [exists(reflexive_pronoun),empty(dir_obj_phr),not_attribute(case(acc),pron_list(pronoun))],
      concord([gender,plurality],subj_phr(pronoun),[])
     ). 
check([sub_clause(past_participle)],
      sentence,
      [exists(relative_subject),exists(sub_clause(reflexive_pronoun)),empty(sub_clause(dir_obj_phr)),not_attribute(case(acc),sub_clause(pron_list(pronoun)))],
      concord([gender,plurality],main_clause(pron_list(pronoun)),[attribute(case(acc))])
     ). 
check([past_participle],
      main_clause,
      [attribute(conjug_with(avoir),past_participle),empty(reflexive_pronoun),attribute(pp_agree(y),pos_or_neg_verb_cons(pron_list(pronoun))),empty(infinitive_phr)],
      concord([gender,plurality],pos_or_neg_verb_cons(pron_list(pronoun)),[attribute(pp_agree(y))])
     ). 
check([past_participle],
      sub_clause,
      [attribute(conjug_with(avoir),past_participle),empty(reflexive_pronoun),attribute(pp_agree(y),pos_or_neg_verb_cons(pron_list(pronoun))),empty(infinitive_phr)],
      concord([gender,plurality],pos_or_neg_verb_cons(pron_list(pronoun)),[attribute(pp_agree(y))])
     ). 
check([sub_clause(past_participle)],
      sentence,
      [exists(relative_object_que),attribute(conjug_with(avoir),sub_clause(past_participle)),empty(sub_clause(reflexive_pronoun)),exists(main_clause(dir_obj_phr))],
      concord([gender,plurality],main_clause(dir_obj_phr(noun)),[])
     ). 
check([past_participle],
      main_clause,
      [attribute(conjug_with(avoir),past_participle),exists(reflexive_pronoun),exists(dir_obj_phr)],
      should_be([gender(m),plurality(s)])
     ). 
check([past_participle],
      sub_clause,
      [attribute(conjug_with(avoir),past_participle),exists(reflexive_pronoun),exists(dir_obj_phr)],
      should_be([gender(m),plurality(s)])
     ). 
check([past_participle],
      main_clause,
      [attribute(conjug_with(avoir),past_participle),empty(reflexive_pronoun),not_attribute(pp_agree(y),pos_or_neg_verb_cons(pron_list(pronoun)))],
      should_be([gender(m),plurality(s)])
     ). 
check([past_participle],
      sub_clause,
      [empty(relative_object_que),attribute(conjug_with(avoir),past_participle),empty(reflexive_pronoun),not_attribute(pp_agree(y),pos_or_neg_verb_cons(pron_list(pronoun)))],
      should_be([gender(m),plurality(s)])
     ). 
check([past_participle],
      main_clause,
      [attribute(conjug_with(avoir),past_participle),empty(reflexive_pronoun),exists(infinitive_phr)],
      should_be([gender(m),plurality(s)])
     ). 
check([past_participle],
      sub_clause,
      [attribute(conjug_with(avoir),past_participle),empty(reflexive_pronoun),exists(infinitive_phr)],
      should_be([gender(m),plurality(s)])
     ). 
check([aux_verb],
      pos_or_neg_verb_cons,
      [attribute(conjug_with(avoir),past_participle),empty(reflexive_pronoun)],
      change_word("avoir",aux_verb,ignore([transitivity]))
     ). 
check([aux_verb],
      pos_or_neg_verb_cons,
      [attribute(conjug_with(e4tre),past_participle)],
      change_word("e4tre",aux_verb,ignore([transitivity]))
     ). 
check([aux_verb],
      pos_or_neg_verb_cons,
      [exists(reflexive_pronoun)],
      change_word("e4tre",aux_verb,ignore([transitivity]))
     ). 
check([aux_verb],
      main_clause,
      [exists(compliment_phr)],
      change_word("e4tre",aux_verb,ignore([transitivity]))
     ). 
check([aux_verb],
      sub_clause,
      [exists(compliment_phr)],
      change_word("e4tre",aux_verb,ignore([transitivity]))
     ). 
check([compliment_phr(adjective)],
      main_clause,
      [],
      concord([gender,plurality],subj_phr(noun),[])
     ). 
check([sub_clause(compliment_phr(adjective))],
      sentence,
      [exists(relative_subject)],
      concord([gender,plurality],main_clause(dir_obj_phr(noun)),[])
     ). 
check([compliment_phr(adjective)],
      main_clause,
      [],
      concord([gender,plurality],subj_phr(pronoun),[])
     ). 
check([sub_clause(compliment_phr(adjective))],
      sentence,
      [exists(relative_subject)],
      concord([gender,plurality],main_clause(pron_list(pronoun)),[attribute(case(acc))])
     ). 
check([governing_verb],
      verb_phr,
      [attribute(transitivity(i),governing_verb),exists(dir_obj_phr)],
      comment([verb_phr,[]],'Verb is intransitive so does not expect an object')
     ). 
check([governing_verb],
      verb_phr,
      [attribute(transitivity(i),governing_verb)],
      comment([verb_phr,[attribute(transitivity(i),governing_verb),attribute(case(acc),pos_or_neg_verb_cons(pronoun))]],'Verb is intransitive so does not expect an object')
     ). 
check([governing_verb],
      main_clause,
      [attribute(transitivity(t),governing_verb),empty(dir_obj_phr),empty(reflexive_pronoun),empty(infinitive_phr),empty(compliment_phr)],
      comment([verb_phr,[attribute(transitivity(t),governing_verb),empty(dir_obj_phr),empty(reflexive_pronoun),not_attribute(case(acc),pos_or_neg_verb_cons(pronoun)),empty(infinitive_phr),empty(compliment_phr)]],'Verb is transitive so does expect an object')
     ).
check([governing_verb],
      sentence,
      [attribute(transitivity(t),sub_clause(governing_verb)),empty(sub_clause(dir_obj_phr)),empty(sub_clause(reflexive_pronoun)),empty(sub_clause(infinitive_phr)),empty(sub_clause(compliment_phr)),empty(relative_object)],
      comment([verb_phr,[attribute(transitivity(t),sub_clause(governing_verb)),empty(sub_clause(dir_obj_phr)),empty(sub_clause(reflexive_pronoun)),not_attribute(case(acc),sub_clause(pos_or_neg_verb_cons(pronoun))),empty(sub_clause(infinitive_phr)),empty(sub_clause(compliment_phr)),empty(relative_object)]],'Verb is transitive so does expect an object')
     ).
check([governing_verb],
      verb_phr,
      [exists(reflexive_pronoun),attribute(can_be_reflex(n),governing_verb)],
      comment([verb_phr,[]],'This verb cannot be used reflexively')
     ).
check([governing_verb],
      verb_phr,
      [exists(infinitive_phr),attribute(follow_prepos([]),governing_verb)],
      comment([verb_phr,[]],'This verb cannot be followed by an infinitive phrase')
     ).
check([governing_verb],
      verb_phr,
      [exists(infinitive_phr),not_attribute(follow_prepos([]),governing_verb),not_one_of(follow_prepos,verb_preposition,governing_verb)],
      comment([verb_phr,[]],'Wrong preposition used after this verb')
     ).
check([sub_clause(governing_verb)],
      sentence,
      [exists(relative_object_si)],
      comment([sentence,[exists(relative_object_si),not_attribute(tense(present),sub_clause(governing_verb)),not_attribute(tense(imperfect),sub_clause(governing_verb))]],'''si'' can only be followed by either the present or imperfect tenses')
      ).
check([main_clause(governing_verb)],
      sentence,
      [exists(relative_object_si)],
      comment([sentence,[exists(relative_object_si),attribute(tense(present),sub_clause(governing_verb)),not_attribute(tense(future),main_clause(governing_verb))]],'If ''si'' is followed by the present tense, the main clause should be in the future')
      ).
check([main_clause(governing_verb)],
      sentence,
      [exists(relative_object_si)],
      comment([sentence,[exists(relative_object_si),attribute(tense(imperfect),sub_clause(governing_verb)),not_attribute(tense(conditional),main_clause(governing_verb))]],'If ''si'' is followed by the imperfect tense, the main clause should be in the conditional')
      ).
 
reorder(beginning,noun_phr,[priority(1,determiner,[]),priority(2,adjective,[position(pre)]),priority(3,noun,[]),priority(4,adjective,[position(post)])]).

reorder(end,pron_list,[priority(2,pronoun,[order(2)]),priority(3,pronoun,[order(3)]),priority(4,pronoun,[order(4)]),priority(5,pronoun,[order(5)])]).

change_spelling([letter(vowel,first_letter,following_word)],[apostrophe(y)]). 
change_spelling([letter(consonant,first_letter,following_word)],[apostrophe(n)]). 

spelling_change_attribute(apostrophe).
