/*  ENGLISH  DICTIONARY  */
/*  1988  */

/*  STANDARD  ENDINGS  */

info(gp_end,[[plurality(s)],[plurality(p)],[plurality(s)],[plurality(p)]],[],[]).

ending_type(gp_end,["","","",""],[]).

/*  NOUNS  */

info(noun,[[plurality(s)],[plurality(p)]],[],[person(3)]).


word("",["boat"],noun,["","s"],[]).
word("",["bank"],noun,["","s"],[]).
word("",["cat"],noun,["","s"],[]).
word("",["dog"],noun,["","s"],[]).
word("",["church"],noun,["","es"],[]).
word("",["wom"],noun,["an","en"],[]).
word("",["girl"],noun,["","s"],[]).
word("",["boy"],noun,["","s"],[]).
word("",["man"],noun,["","men"],[]).
word("",["book"],noun,["","s"],[]).
word("",["hand"],noun,["","s"],[]).
word("",["house"],noun,["","s"],[]).
word("",["mother"],noun,["","s"],[]).
word("",["mat"],noun,["","s"],[]).
word("",["mensonge"],noun,["","s"],[]).
word("",["father"],noun,["","s"],[]).
word("",["pen"],noun,["","s"],[]).
word("",["apple"],noun,["","s"],[]).
word("",["aunt"],noun,["","s"],[]).
word("",["tour"],noun,["","s"],[]).
word("",["glass"],noun,["","es"],[]).

/*  PRONOUNS  */

info(pronoun,[
[case(nom),apostrophe(n),order(1)],[case(nom),apostrophe(y),order(1)],
[case(acc),apostrophe(n),pp_agree(y),order(2)],[case(acc),apostrophe(y),pp_agree(y),order(2)],
[case(dat),apostrophe(n),order(3)],[case(dat),apostrophe(y),order(3)],
[case(dat),order(4)],
[case(acc),order(5)]
],[person,plurality],[]).

word("i",[""],pronoun,["i","i","my","my","my","my","",""],[1,s]).
word("you",[""],pronoun,["you","you","your","your","your","your","",""],[2,s]).
word("he",[""],pronoun,["he","he","his","his","his","his","",""],[3,s]).
word("she",[""],pronoun,["she","she","her","her","her","her","",""],[3,s]).
word("we",[""],pronoun,["we","","our","","our","","",""],[1,p]).
word("you",[""],pronoun,["you","","your","","your","","",""],[2,p]).
word("they",[""],pronoun,["they","","their","","their","","",""],[3,p]).
word("elles",[""],pronoun,["they","","their","","their","","",""],[3,p]).

/*  REFLEXIVE  PRONOUNS  */

info(reflexive_pronoun,[[apostrophe(n)],[apostrophe(y)]],[person,plurality],[]).

word("myself",[""],reflexive_pronoun,["",""],[1,s]).
word("yourself",[""],reflexive_pronoun,["",""],[2,s]).
word("himself",[""],reflexive_pronoun,["",""],[3,s]).
word("ourselves",[""],reflexive_pronoun,["",""],[1,p]).
word("themselves",[""],reflexive_pronoun,["",""],[2,p]).
word("oneself",[""],reflexive_pronoun,["",""],[3,p]).

/*  ADJECTIVES  */

info(adjective,[],[position],[]).

word("",["big"],adjective,[],[pre]).
word("",["happy"],adjective,[],[pre]).
word("",["new"],adjective,[],[pre]).
word("",["small"],adjective,[],[pre]).

word("",["white"],adjective,[],[pre]).
word("",["gentle"],adjective,[],[pre]).
word("",["lucky"],adjective,[],[pre]).
word("",["intelligent"],adjective,[],[pre]).
word("",["ugly"],adjective,[],[pre]).
word("",["slow"],adjective,[],[pre]).
word("",["rapid"],adjective,[],[pre]).
word("",["stupid"],adjective,[],[pre]).
word("",["green"],adjective,[],[pre]).

/*  ADVERBS  */

info(adverb,[],[],[]).

word("",["constantly"],adverb,[],[]).
word("",["slowly"],adverb,[],[]).
word("",["quickly"],adverb,[],[]).
word("",["gently"],adverb,[],[]).

/*  DETERMINERS  */

info(determiner,[[]],[],[]).

word("",["these"],determiner,[""],[]).
word("",["the"],determiner,[""],[]).
word("",["a"],determiner,[""],[]).

word("",["my"],determiner,["","","","","",""],[]).
word("",["your"],determiner,["","","","","",""],[]).
word("",["her"],determiner,["her","","hers","","",""],[]).
word("",["our"],determiner,["our","","","","","ours"],[]).
word("",["their"],determiner,["their","","","","",""],[]).
word("",["their"],determiner,["","","","","",""],[]).

info(conjunction,[[]],[],[]).
word("",["and"],conjunction,[""],[]).
word("",["but"],conjunction,[""],[]).

/*  VERBS  */

info(verb,[type],[transitivity,follow_prepos,can_be_reflex],[]).

word("like",["like"],verb,reg_end,[t,["to",""],y]).
word("go",[""],verb,go_end,[i,["to",""],n]).
word("arrive",["arrive"],verb,reg_end,[i,["at",""],n]).
word("sing",["sing"],verb,reg_end,[i,["to",""],n]).
word("commence",["commenc"],verb,reg_end,[t,[""],n]).
word("decide",["decid"],verb,reg_end,[t,["to",""],n]).
word("give",["give"],verb,reg_end,[t,["up",""],y]).
word("do",[""],verb,do_end,[t,[],n]).
word("wash",["wash"],verb,reg_end1,[t,[],y]).
word("eat",["eat"],verb,reg_end,[t,[],n]).
word("walk",["walk"],verb,reg_end,[i,["to",""],n]).
word("talk",["talk"],verb,reg_end,[i,["to",""],y]).
word("see",[""],verb,see_end,[t,["to",""],y]).
word("travel",["travel"],verb,reg_end,[i,["to",""],n]).

word("run",["run"],verb,reg_end,[t,["to",""],n]).
word("finish",["finish"],verb,reg_end,[t,[],n]).
word("leave",["leave"],verb,reg_end_16,[i,["to",""],n]).

word("understand",["understand"],verb,reg_end,[t,[],n]).
word("be",[""],verb,be_end,[t,[],n]).
word("will",[""],verb,will_end,[t,[],n]).

/*  VERB  ENDINGS  */

info(reg_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

actual_endings(reg_end_pres,["","","s","","",""]).
actual_endings(reg_end_imp,["ed","ed","ed","ed","ed","ed"]).
actual_endings(reg_end_fut,["","","","","",""]).
actual_endings(reg_end_cond,["","","","","",""]).

ending_type(reg_end,reg_end_pres,[present]).
ending_type(reg_end,reg_end_imp,[imperfect]).
ending_type(reg_end,reg_end_fut,[future]).
ending_type(reg_end,reg_end_cond,[conditional]).

info(reg_end1,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

actual_endings(reg_end1_pres,["","","es","","",""]).
actual_endings(reg_end1_imp,["ed","ed","ed","ed","ed","ed"]).

ending_type(reg_end1,reg_end1_pres,[present]).
ending_type(reg_end1,reg_end1_imp,[imperfect]).


info(irreg_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

actual_endings(irreg_end_pres,["","","es","","",""]).
actual_endings(irreg_end_imp,["","","","","",""]).
actual_endings(irreg_end_fut,["","","","","",""]).
actual_endings(irreg_end_cond,["","","","","",""]).

ending_type(irreg_end,irreg_end_pres,[present]).
ending_type(irreg_end,irreg_end_imp,[imperfect]).
ending_type(irreg_end,irreg_end_fut,[future]).
ending_type(irreg_end,irreg_end_cond,[conditional]).

info(go_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

ending_type(go_end,["go","go","goes","go","go","go"],[present]).
ending_type(go_end,["went","went","went","went","went","went"],[imperfect]).
ending_type(go_end,["go","go","goes","go","go","go"],[future]).

info(be_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

ending_type(be_end,["am","are","is","are","are","are"],[present]).
ending_type(be_end,["was","were","was","were","were","were"],[imperfect]).
ending_type(be_end,["","","","","",""],[future]).

info(will_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

ending_type(will_end,["will","will","will","will","will","will"],[present]).
ending_type(will_end,["would","would","would","would","would","would"],[imperfect]).
ending_type(go_end,["will","will","will","will","will","will"],[future]).



info(do_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

ending_type(do_end,["do","do","does","do","do","do"],[present]).
ending_type(do_end,["did","did","did","did","did","did"],[imperfect]).

info(see_end,[[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],
[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]],[tense],[]).

ending_type(see_end,["see","see","sees","see","see","see"],[present]).
ending_type(see_end,["saw","saw","saw","saw","saw","saw"],[imperfect]).

/*  AUXILIARY  VERBS  */
info(aux_verb,[
[person(1),plurality(s)],[person(2),plurality(s)],[person(3),plurality(s)],[person(1),plurality(p)],[person(2),plurality(p)],[person(3),plurality(p)]
],[tense,transitivity],[]).

word("have",[""],aux_verb,["have","have","has","have","have","have"],[past,t]).
word("have",[""],aux_verb,["had","had","had","had","had","had"],[imperfect,t]).

word("be",[""],aux_verb,["am","are","is","are","are","are"],[present,t]).
word("be",[""],aux_verb,["was","were","was","were","were","were"],[imperfect,t]).

word("will",[""],aux_verb,["will","will","will","will","will","will"],[future,t]).
word("did",[""],aux_verb,["did","did","did","did","did","did"],[past,t]).

/*  PAST  PARTICIPLES  */

info(past_participle,[[plurality(s)],[plurality(p)]],[conjug_with,transitivity,follow_prepos,can_be_reflex],[]).

word("",["liked"],past_participle,gp_end,[t,[""],y]).
word("",["gone"],past_participle,gp_end,[i,[""],n]).
word("",["arrived"],past_participle,gp_end,[i,[],n]).
word("",["sung"],past_participle,gp_end,[i,[],n]).
word("",["commenced"],past_participle,gp_end,[t,[""],n]).
word("",["run"],past_participle,gp_end,[i,[],n]).
word("",["did"],past_participle,gp_end,[t,[],n]).
word("",["finshedi"],past_participle,gp_end,[t,[""],n]).
word("",["decided"],past_participle,gp_end,[t,[""],n]).
word("",["gave"],past_participle,gp_end,[t,[],y]).
word("",["understood"],past_participle,gp_end,[t,[""],n]).
word("",["washed"],past_participle,gp_end,[t,[],y]).
word("",["ate"],past_participle,gp_end,[t,[],n]).
word("",["walked"],past_participle,gp_end,[i,[],n]).
word("",["talked"],past_participle,gp_end,[i,[],y]).
word("",["went"],past_participle,gp_end,[i,[],n]).
word("",["voyage1"],past_participle,gp_end,[i,[],n]).
word("",["saw"],past_participle,gp_end,[t,[""],n]).

/*  INFINITIVES  */

info(infinitive,[[plurality(s)],[plurality(p)]],[transitivity,follow_prepos],[]).

word("",["like"],infinitive,["",""],[t,y]).
word("",["go"],infinitive,["",""],[i,n]).
word("",["arrive"],infinitive,["",""],[i,n]).
word("",["sing"],infinitive,["",""],[i,n]).
word("",["commence"],infinitive,["",""],[t,n]).
word("",["run"],infinitive,["",""],[i,n]).
word("",["decide"],infinitive,["",""],[t,n]).
word("",["give"],infinitive,["",""],[t,y]).
word("",["understand"],infinitive,["",""],[t,n]).
word("",["do"],infinitive,["",""],[t,n]).
word("",["finish"],infinitive,["",""],[t,n]).
word("",["wash"],infinitive,["",""],[t,y]).
word("",["eat"],infinitive,["",""],[t,n]).
word("",["walk"],infinitive,["",""],[i,n]).
word("",["talk"],infinitive,["",""],[i,y]).
/*word("",["leave"],infinitive,["",""],[i,n]). */
word("",["go"],infinitive,["",""],[i,n]).
word("",["travel"],infinitive,["",""],[i,n]).
word("",["see"],infinitive,["",""],[t,y]).
word("",["be"],infinitive,["",""],[t,y]).

/*  NEGATIVE  CONSTRUCTS  */

info(neg_begin,[[]],[],[]).

word("no",[""],neg_begin,["no","no"],[]).
word("never",[""],neg_begin,["never","never"],[]).

info(neg_end,[[]],[],[]).

word("not",[""],neg_end,["not"],[]).
word("never",[""],neg_end,["never"],[]).

/*  PREPOSITIONS  */

info(preposition,[[]],[],[]).

word("to",[""],preposition,["to"],[]).
word("from",[""],preposition,["from"],[]).
word("a",[""],preposition,["a"],[]).
word("in",[""],preposition,["in"],[]).
word("of",[""],preposition,["of"],[]).
word("on",[""],preposition,["on"],[]).
word("towards",[""],preposition,["towards"],[]).
word("at",[""],preposition,["at"],[]).

/*  RELATIVES  */

info(relative_subject,[[]],[],[]).

word("which",[""],relative_subject,["which"],[]).
word("who",[""],relative_subject,["who"],[]).
word("that",[""],relative_subject,["that"],[]).

info(relative_object_que,[[apostrophe(n)],[apostrophe(y)]],[],[]).

word("that",[""],relative_object_que,["that","that"],[]).

info(relative_object_si,[[apostrophe(n)],[apostrophe(y)]],[],[]).

word("if",[""],relative_object_si,["if","s'"],[]).

/*  GUESS  CLASS  */

open1(noun).
open1(adjective).
open1(adverb).
open1(verb).
open1(past_participle).
open1(infinitive).

insert_type(noun).
insert_type(adjective).
insert_type(verb).
insert_type(adverb).
insert_type(past_participle).
insert_type(infinitive).
insert_type(determiner).
insert_type(pronoun).
insert_type(reflexive_pronoun).
insert_type(relative_subject).
insert_type(relative_object_que).
insert_type(relative_object_si).
insert_type(aux_verb).
insert_type(preposition).
insert_type(neg_begin).
insert_type(neg_end).
vowels("aeiou").


