/* 
 * tk.c - modified from the source file TkMain.c
 *	As we want to use the main() of Prolog and not the main() of wish,
 *	I had to make a tk_init function out of the main().
 *
 *	Author: Micha Meier
 *	Date:	September 93
 *		Created the file.
 *

 *      slightly modified by Gertjan van Noord, cf. README.GJ

 *	Comments:
 *		- This interface is very simple, all it does is to
 *		  allow call Tcl/Tk commands from Prolog. It does
 *		  not implement Tk commands themselves in Prolog, although
 *		  this would be useful, because we'd prefer not to
 *		   use Tcl to parse and interpret all these calls.
 *
 *		- Prolog systems that allow calling C from Prolog can use
 *		  the new 'prolog' Tcl command to write callback
 *		  procedures that execute Prolog calls. The syntax is
 *			prolog {proc arg1 [args ...]} [module]
 *		  and it corresponds to
 *			module:proc(arg1, ...)
 *		  Currently this command works only for ECLiPSe and SICStus,
 *		  arguments can be only numbers and strings, the default
 *		  module is 'eclipse' or 'user', respectively.
 *
 *		- The interactive features of wish are available only in
 *		  ECLiPSe and SICStus. The problem with making this possible
 *		  is that all wish has to do is wait for some input on stdin
 *		  or X events and to interpret them. In Prolog, we want
 *		  to do the same, however it is the Prolog top-level
 *		  loop that waits for data on stdin and it usually blocks
 *		  so that it cannot simultaneously process X events.
 *		  The solution is as follows: Tk has a file
 *		  handler for the standard input, the handling
 *		  procedure is void. In Eclipse, the Prolog top-level
 *		  loop does not make a read, but it calls
 *		  tk_do_one_event/2. This serves an event, which may
 *		  be either an X event or it signalls that data is ready
 *		  on input. To distinguish between these two cases,
 *		  the top_level loop then calls select/3 to find
 *		  out if there is any data on standard input and if so,
 *		  it makes a read, executes the query and goes
 *		  back to tk_do_one_event/1. In ECLiPSe this is simple
 *		  to do because there are hooks in the top-level loop
 *		  that allow to call user predicates inside, and
 *		  there is a select/3 predicate available.
 *		  In SICStus, the SP_read_hook is used so that it even serves
 *		  the events on each read (not only in the toplevel).
 *
 *		- ECLiPSe allows callbacks in Prolog via the Tcl command
 *		  'prolog_event"
 *
 *		- The 'exit' command in Tcl/Tk exits only Tk and returns
 *		  back to Prolog. To make a complete exit in Tk,
 *		  use the Tcl command 'exit_prolog'.
 *
 *		- Note that some parts of Tk's main() are executed separately
 *		  in Prolog and not in tk_init.
 *
 *		- For convenience, the interface assumes that the same
 *		  Tcl interpreter is used all the time and thus it does
 *		  not have to be passed as argument of each tcl_eval
 *		  call. It is trivial to modify the code so that
 *		  different Tcl interpreters are available.
 *
 *******************************************************************
 * main.c --
 *
 *	This file contains the main program for "wish", a windowing
 *	shell based on Tk and Tcl.  It also provides a template that
 *	can be used as the basis for main programs for other Tk
 *	applications.
 *
 * Copyright (c) 1990-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef lint
static char rcsid[] = "$Header: /user6/ouster/wish/RCS/tkMain.c,v 1.94 93/08/28 17:00:50 ouster Exp $ SPRITE (Berkeley)";
static char     *SccsId   = "@(#)tk.c	1.8        94/01/25";
static char     *SccsCr   = "@(#)  Changes Copyright 1993 ECRC GmbH";
#endif

#ifdef ECLIPSE
#include "external.h"
#undef EXTERN
static word32		d_eclipse;
static pword		*event_data = 0;
#endif

#ifdef SICSTUS
#include "Runtime/runtime.h"
int		tk_event_hook();
#endif

#include <stdio.h>
#include <tcl.h>
#include <tk.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>

#define ARGV(i)				"prolog"

/*
 * Declarations for various library procedures and variables (don't want
 * to include tkInt.h or tkConfig.h here, because people might copy this
 * file out of the Tk source directory to make their own modified versions).
 */

extern void             exit _ANSI_ARGS_((int status));
extern int              isatty _ANSI_ARGS_((int fd));
extern int              read _ANSI_ARGS_((int fd, char *buf, size_t size));
extern char *           strrchr _ANSI_ARGS_((CONST char *string, int c));

/*
 * Global variables used by the main program:
 */

static Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */
static Tcl_Interp *interp = NULL; /* Interpreter for this application. */
char *tcl_RcFileName = NULL;  /* Name of a user-specific startup script
				 * to source if the application is being run
				 * interactively (e.g. "~/.wishrc").  Set
				 * by Tcl_AppInit.  NULL means don't source
				 * anything ever. */
extern int		Tcl_ExitCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));


/*
 * Forward declarations for procedures defined later in this file:
 */

int			Tk_PrologCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));
int			Tk_PrologEventCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));
int			Tcl_ExitTkCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));

#ifdef TK_TEST
int			TestmakeexistCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));
#endif

static void		ToplevelProc _ANSI_ARGS_((ClientData clientData,
			    int mask));

static int		call_prolog();

static int synchronize = 0;
static char *name = NULL;
static char *display = NULL;
static char *geometry = NULL;

extern char	*strrchr();

#ifdef ECLIPSE
/*
 * tk_option(Option, Value)
 */
p_tk_option(vo, to, vv, tv)
value		vo, vv;
type		to, tv;
{
    char	*o, *v;

    Get_Name(vo, to, o);
    Get_Name(vv, tv, v);
    tk_option(o, v);
    Succeed;
}

/*
 *	tk_init(File)
 *		Initialize Tk so that we obtain the functionality of wish
 */
p_tk_init(vf, tf)
value		vf;
type		tf;
{
    char	*file;

    Get_Name(vf, tf, file);
    d_eclipse = Did("eclipse", 0);
    Succeed_If(tk_init(file) == 0);
}

p_tk_do_one_event(v, t, vl, tl)
value		v, vl;
type		t, tl;
{
    Check_Integer(t)
    event_data = NULL;
    if (Tk_DoOneEvent((int) v.nint) == 0) {
	Fail
    }
    if (event_data) {
	Return_Unify_List(vl, tl, event_data->val.ptr)
    }
    Return_Unify_Integer(vl, tl, 0)
}


/*
 *	tcl_eval_string(String)
 *		Send the string to Tcl
 */
p_tcl_eval_string(vs, ts)
value		vs;
type		ts;
{
    char	*cmd;

    Get_Name(vs, ts, cmd);
    Succeed_If(tcl_eval_string(cmd) == 0);
}

p_tk_num_main_windows(v, t)
value		v;
type		t;
{
    Check_Output_Integer(t)
    Return_Unify_Integer(v, t, tk_NumMainWindows)
}
#endif

tk_option(atom, string)
char	*atom;
char	*string;
{
    if (!strcmp(atom, "geometry"))
	geometry = string;
    else if (!strcmp(atom, "display"))
	display = string;
    else if (!strcmp(atom, "name"))
	name = string;
    else if (!strcmp(atom, "sync"))
	synchronize = 1;
}

tk_init(file)
char	*file;
{
    char	*p;
    char	*fileName;
    int		code;

    fileName = file;
    if (!strcmp(fileName, ""))
	fileName = NULL;

    if (!interp)
	interp = Tcl_CreateInterp();

    if (name == NULL) {
	if (fileName != NULL) {
	    p = fileName;
	} else {
	    p = ARGV(0);
	}
	name = strrchr(p, '/');
	if (name != NULL) {
	    name++;
	} else {
	    name = p;
	}
    }

    /*
     * If a display was specified, put it into the DISPLAY
     * environment variable so that it will be available for
     * any sub-processes created by us.
     */

    if (display != NULL) {
	Tcl_SetVar2(interp, "env", "DISPLAY", display, TCL_GLOBAL_ONLY);
    }

    /*
     * Initialize the Tk application.
     */

    mainWindow = Tk_CreateMainWindow(interp, display, name, "Tk");
    if (mainWindow == NULL) {
	printf("%s\n", interp->result);
	return 1;
    }
    if (synchronize) {
	XSynchronize(Tk_Display(mainWindow), True);
    }
    Tk_GeometryRequest(mainWindow, 200, 200);

    Tcl_SetVar(interp, "argc", "0", TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", (fileName != NULL) ? fileName : ARGV(0),
	    TCL_GLOBAL_ONLY);
    if (geometry != NULL) {
	Tcl_SetVar(interp, "geometry", geometry, TCL_GLOBAL_ONLY);
    }

    /*
     * Set the "tcl_interactive" variable. In Prolog we consider
     * it never as interactive.
     */

    Tcl_SetVar(interp, "tcl_interactive",
	    (fileName == NULL) ? "0" : "0", TCL_GLOBAL_ONLY);

    /*
     * Add a few application-specific commands to the application's
     * interpreter.
     */

    Tcl_CreateCommand(interp, "exit_prolog", Tcl_ExitCmd, (ClientData) NULL,
	    (void (*)()) NULL);
    Tcl_CreateCommand(interp, "exit", Tcl_ExitTkCmd, (ClientData) NULL,
	    (void (*)()) NULL);
    Tcl_CreateCommand(interp, "prolog", Tk_PrologCmd, (ClientData) NULL,
	    (void (*)()) NULL);
    Tcl_CreateCommand(interp, "prolog_event", Tk_PrologEventCmd,
	    (ClientData) NULL, (void (*)()) NULL);
#ifdef TK_TEST
    Tcl_CreateCommand(interp, "testmakeexist", TestmakeexistCmd,
	    (ClientData) Tk_MainWindow(interp), (Tcl_CmdDeleteProc *) NULL);
#endif

/* TKXACCESS initialiation. Added by Gertjan van Noord. */
#ifdef TKXACCESS
    if (TkXAccess_Init(interp) != TCL_OK) {
      fprintf(stderr, "TkXAccess_Init failed: %s\n", interp->result);
      }
#endif
    /*
     * Invoke application-specific initialization.
     *

    if (Tcl_AppInit(interp) != TCL_OK) {
	fprintf(stderr, "Tcl_AppInit failed: %s\n", interp->result);
    }
    */

    /*
     * Set the geometry of the main window, if requested.
     */

    if (geometry != NULL) {
	code = Tcl_VarEval(interp, "wm geometry . ", geometry, (char *) NULL);
	if (code != TCL_OK) {
	    fprintf(stderr, "%s\n", interp->result);
	}
    }

    /*
     * If there is no file to execute, set a handler to wait
     * for input on the toplevel input stream.
     */

    if (fileName == NULL) {
	Tk_CreateFileHandler(0 /* should be StreamUnit(toplevel_input_)*/,
		TK_READABLE, ToplevelProc, (ClientData) 0);
    }
#ifdef SICSTUS
    SP_read_hook = tk_event_hook;
#endif
    return 0;
}

tcl_eval_string(cmd)
char		*cmd;
{
    int		res;

    if (!interp)
	return 1;
# ifdef GCC
    res = Tcl_Eval(interp, cmd);
# else
    res = Tcl_Eval(interp, cmd, 0, (char **) NULL);
# endif
    if (res != TCL_OK) {
	cmd = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
	if (cmd == NULL) {
	    cmd = interp->result;
	}
	printf("%s\n", cmd);
	return 1;
    }
    return 0;
}

tk_num_main_windows()
{
    return tk_NumMainWindows;
}


/*
 *----------------------------------------------------------------------
 *
 * ToplevelProc --
 *
 *	This procedure is invoked by the event dispatcher whenever
 *	toplevel input becomes readable.  It is here only to give
 *	the toplevel loop the opportunity to get the input and execute it.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
static void
ToplevelProc(clientData, mask)
    ClientData clientData;		/* Not used. */
    int mask;				/* Not used. */
{
}

#ifdef ECLIPSE
/*
 * This command makes an interface between Tk events and handlers
 * written in Prolog. When specified as an event handler, it will
 * save the required data and return. Prolog is then able
 * to retrieve the stored data and invoke the appropriate
 * Prolog predicate.
 */
int
Tk_PrologEventCmd(data, interp, argc, argv)
    ClientData data;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    register pword	*p;
    pword		result;
    int			i;
    extern char		*string_to_number();

    event_data = p = TG++;
    Check_Gc
    for (i = 1; i < argc; i++) {
	p->val.ptr = TG;
	p->tag.kernel = TLIST;
	p = TG;
	TG += 2;
	Check_Gc
	if (*string_to_number(argv[i], p, (stream_id) 0, 0) ||
		IsTag(p->tag.kernel, TEND))
	{
	    Cstring_To_Prolog(argv[i], p->val);
	    p->tag.all = TSTRG;
	}
	p++;
    }
    p->tag.kernel = TNIL;
    return TCL_OK;
}
#else
int
Tk_PrologEventCmd(data, interp, argc, argv)
    ClientData data;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    Tcl_AppendResult(interp,
	"prolog_event is not defined for this Prolog system",
	(char *) NULL);
    return TCL_ERROR;
}
#endif


int
Tk_PrologCmd(data, interp, argc, argv)
    ClientData data;			/* Not used. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    int		res, argCount;
    char	**argArray;

    if (argc < 2 || argc > 3) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		" pred [module]\"", (char *) NULL);
	return TCL_ERROR;
    }
    res = Tcl_SplitList(interp, argv[1], &argCount, &argArray);
    if (res != TCL_OK)
	return TCL_ERROR;
    res = call_prolog(argCount, argArray, argc, argv);
    if (res != 0) {
	Tcl_AppendResult(interp, "prolog goal failed", (char *) NULL);
	return TCL_ERROR;
    } else
	return TCL_OK;
}

#ifdef ECLIPSE
static int
call_prolog(argCount, argArray, argc, argv)
char		**argArray, **argv;
int		argCount, argc;
{
    value	vmod, vg;
    pword	*p = TG;
    extern type	tdict, tcomp;
    pword	result;
    int		i;
    extern char	*string_to_number();

    vmod.did = (argc == 3) ? in_dict(argv[2], 0) : d_eclipse;
    vg.did = in_dict(argArray[0], argCount - 1);
    if (argCount == 1) {
	return sub_emulc(vg, tdict, vmod, tdict);
    } else {
	TG += argCount;
	Check_Gc;
	p[0].val.did = vg.did;
	p[0].tag.all = TDICT;
	for (i = 1; i < argCount; i++) {
	    if (!*string_to_number(argArray[i], &result, (stream_id) 0, 0) &&
		!IsTag(result.tag.kernel, TEND))
		p[i].tag.all = result.tag.all;
	    else {
		Cstring_To_Prolog(argArray[i], result.val);
		p[i].tag.all = TSTRG;
	    }
	    p[i].val.nint = result.val.nint;
	}
	vg.ptr = p;
	return sub_emulc(vg, tcomp, vmod, tdict);
    }
}

#else
#ifdef SICSTUS
#define MAXARGS		5
static int
call_prolog(argCount, argArray, argc, argv)
char		**argArray, **argv;
int		argCount, argc;
{
    SP_pred_ref		pred;
    SP_term		args[MAXARGS];
    SP_qid		q;
    char		*mod;
    int			i = 0;

    mod = (argc == 3) ? argv[2] : "user";
    pred = SP_predicate(argArray[0], argCount - 1, mod);
    if (!pred)
	return 0;
    for (i = 1; i < argCount; i++) {
	SP_put_string(args + i - 1, argArray[i]);
    }
/*
    q = SP_open_query_array(pred, args);
    if (q)
	i = SP_close_query(q);
*/
    i = SP_query_cut_fail(pred, args, args+1, args+2, args+3, args+4);
    return (i == 0) ? 1 : 0;
}

int
tk_event_hook(fd)
int	fd;
{
    if (tk_NumMainWindows > 0) {
	(void) Tk_DoOneEvent(0);
	return input_ready(fd);
    } else
	return 1;
}
#else

static int
call_prolog(argCount, argArray, argc, argv)
char		**argArray, argv;
int		argCount, argc;
{
    return 1;
}
#endif
#endif

/*
 *----------------------------------------------------------------------
 *
 * Tcl_ExitCmd --
 *
 *      This procedure is invoked to process the "exit" Tcl command.
 *      Unlike the original Tcl command, this one only exits Tk, but
 *	does not return back to Unix.
 *
 * Results:
 *      A standard Tcl result.
 *
 * Side effects:
 *      See the user documentation.
 *
 *----------------------------------------------------------------------
 */

        /* ARGSUSED */
int
Tcl_ExitTkCmd(dummy, intp, argc, argv)
    ClientData dummy;                   /* Not used. */
    Tcl_Interp *intp;                 /* Current interpreter. */
    int argc;                           /* Number of arguments. */
    char **argv;                        /* Argument strings. */
{
    if ((argc != 1) && (argc != 2)) {
        Tcl_AppendResult(intp, "wrong # args: should be \"", argv[0],
                " ?returnCode?\"", (char *) NULL);
        return TCL_ERROR;
    }
# ifdef GCC
    Tcl_Eval(intp, "destory .");
# else
    Tcl_Eval(intp, "destroy .", 0, (char **) NULL); 
# endif
    Tcl_DeleteInterp(intp);
    interp = NULL;
    return 0;
}

#ifdef TK_TEST
/*
 *----------------------------------------------------------------------
 *
 * TestmakeexistCmd --
 *
 *	This procedure implements the "testmakeexist" command.  It calls
 *	Tk_MakeWindowExist on each of its arguments to force the windows
 *	to be created.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	Creates and deletes interpreters.
 *
 *----------------------------------------------------------------------
 */

	/* ARGSUSED */
static int
TestmakeexistCmd(clientData, interp, argc, argv)
    ClientData clientData;		/* Main window for application. */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings. */
{
    Tk_Window main = (Tk_Window) clientData;
    int i;
    Tk_Window tkwin;

    for (i = 1; i < argc; i++) {
	tkwin = Tk_NameToWindow(interp, argv[i], main);
	if (tkwin == NULL) {
	    return TCL_ERROR;
	}
	Tk_MakeWindowExist(tkwin);
    }

    return TCL_OK;
}
#endif



/*************************************************************
 local stuff
*************************************************************/
int
input_ready(fd)
int	fd;
{
    fd_set		dread;
    struct timeval	to;
    struct timeval	*pto = &to;
    int			max = fd;

    FD_ZERO(&dread);
    FD_SET(fd, &dread);
    to.tv_sec = 0;
    to.tv_usec = 0;

    if (select(max + 1, &dread, (fd_set *) 0, (fd_set *) 0, pto) < 0)
	return -1;
    if (FD_ISSET(fd, &dread))
	return 1;
    else
	return 0;
}
