%
% ProTcl 1.0
%
%	Definitions common to Quintus-like foreign language interface
%
% Author: Micha Meier
% Date:   September 93
%

%
% sccsid("@(#)foreign.pl	1.2          94/01/25").
% sccscr("@(#)  Copyright 1993 ECRC GmbH ").
%

foreign_file('tkXAccess.o',[]).
foreign_file('tk.o',
	[tk_init,
	 tk_option,
	 tcl_eval_string,
	 tk_num_main_windows,
	 'Tk_DoOneEvent',
	 input_ready]).

foreign(tk_init, c, tk_init(+string)).
foreign(tk_option, c, tk_option(+string, +string)).
foreign(tcl_eval_string, c, tcl_eval_string(+string, [-integer])).
foreign(tk_num_main_windows, c, tk_num_main_windows([-integer])).
foreign('Tk_DoOneEvent', c, tk_do_one_event(+integer, [-integer])).
foreign(input_ready, c, input_ready(+integer, [-integer])).
	

 
tcl_eval(S) :-
    tcl_eval_string(S, Err),
    Err = 0.

tk_do_one_event(I) :-
    tk_do_one_event(I, Ev),
    Ev > 0.

concat_atoms(A1, A2, Concat) :-
    name(A1, LA1),
    name(A2, LA2),
    append(LA1, LA2, LA),
    name(Concat, LA).

append([], L, L).
append([X|L1], L2, [X|L3]) :-
    append(L1, L2, L3).

%% use the same options as in the sicstus/Makefile
%% + tk +tkAccess
load_ff :- 
	tk_steal(Bin),
	tk_xaccess(Bin,Rest),
	x11_lib(Prefix),
	concat_atoms(Prefix,'-ltk -ltcl -lX11 -lm',Option),
	load_foreign_files(['tk.o'|Rest], [Option]).

tk_xaccess('0',[]).
tk_xaccess('1',['tkXAccess.o']).

:- load_ff.



