:- module(tk_draw,
	[ tk_string/3,
	  tk_line/4,
	  tk_clear/0,
	  tk_circle/3,
	  tk_fill_circle/3,
	  tk_rect/4,
	  tk_fill_rect/4,
	  tk_polygon/2,
	  tk_fill_polygon/2
        ]).

:- use_module( [ library(tk) ] ).
:- use_module( library(flags) ).
:- use_module( library(concat), [ concat/3,
	                          concat_all/2,
				  concat_all/3,
				  term_atom/2] ).

%% the current canvas should be set-up and available
%% thru flag(canvas,Name)

%% coordinates can always be expressions as they are always
%% first evaluated

font(_C,'-font *-*-medium-r-normal--*-140-*-*-*-*-*-*').

tk_string(X0,Y0,Label0) :-
	flag(canvas,C),
	term_atom(Label0,Label),
	X is X0,
	Y is Y0,
	font(C,Font),
	concat_all([C,' create text ',X,' ',Y,' -text ','{',Label,'} ',Font],
                    Atom),
        user:tcl_eval(Atom).

tk_line(X0,Y0,X,Y) :-
	flag(canvas,C),
	AX is X0, AY is Y0,
	BX is X,  BY is Y,
	concat_all([C,' create line ',AX,' ',AY,' ',BX,' ',BY],Atom),
	user:tcl_eval(Atom).

tk_clear :-
	flag(canvas,C),
	concat(C,' delete all',Atom),
	user:tcl_eval(Atom).

tk_fill_circle(X,Y,W) :-
	flag(canvas,C),
	X0 is X-W,
	Y0 is Y-W,
	X1 is X+W,
	Y1 is Y+W,
	concat_all([C,' create oval ',X0,' ',Y0,' ',
                     X1,' ',Y1,' -fill blue'],Atom),
	user:tcl_eval(Atom).

tk_circle(X,Y,W) :-
	flag(canvas,C),
	X0 is X-W,
	Y0 is Y-W,
	X1 is X+W,
	Y1 is Y+W,
	concat_all([C,' create oval ',X0,' ',Y0,' ',
                     X1,' ',Y1],Atom),
	user:tcl_eval(Atom).

tk_rect(X1,Y1,X2,Y2) :-
	flag(canvas,C),
	XX1 is X1,
	YY1 is Y1,
	XX2 is X2,
	YY2 is Y2,
	concat_all([C,' create rectangle ',XX1,' ',YY1,' ',
                     XX2,' ',YY2],Atom),
	user:tcl_eval(Atom).

tk_fill_rect(X1,Y1,X2,Y2) :-
	flag(canvas,C),
	XX1 is X1,
	YY1 is Y1,
	XX2 is X2,
	YY2 is Y2,
	concat_all([C,' create rectangle ',XX1,' ',YY1,' ',
                     XX2,' ',YY2,' -fill blue'],Atom),
	user:tcl_eval(Atom).

tk_polygon(Xpoints,Ypoints) :-
	points(Xpoints,Ypoints,Points,[]),
	flag(canvas,C),
	concat_all([C,create,polygon|Points],Atom,' '),
	tcl_eval(Atom).

tk_fill_polygon(Xpoints,Ypoints) :-
	points(Xpoints,Ypoints,Points,['-fill',blue]),
	flag(canvas,C),
	concat_all([C,create,polygon|Points],Atom,' '),
	tcl_eval(Atom).

points([],[],L,L).
points([X|Xt],[Y|Yt],[X0,Y0|Zt],T) :-
	X0 is X,
	Y0 is Y,
	points(Xt,Yt,Zt,T).
