%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%% term_expansion %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1. handles constraints (by placing them back in body if necc.)
% 2. handles disjunction as it should be
% 3. allows series of term-expansions
% 4. does not make difference for unit/non-unit clauses
% 5. body is a list, rather than a conjunction

% the user defines a term_expansion as follows
%
% 
%
% adda_expansion(F)
% add_expansion(F)
% addz_expansion(F)
% del_expansion(F)
% where F(Head0,Body0,Head,Body) is defined

:- use_module( library(flags) ).
:- use_module( library(lists), [ delete/3,
	                         append/3 ]).
:- use_module( library(decons), [ prolog_conjunction/2 ] ).

dcg_expansion(H0,B0,H,B) :-
	prolog:dcg_expansion(H0,HB),
        head_body(HB,H,B1),
	append(B1,B0,B).

adda_expansion(F):-
	flag(expansion_list,Old,[F|Old]).

add_expansion(F):-
	flag(expansion_list,Old,[F|Old]).

addz_expansion(F):-
	flag(expansion_list,Old),
	append(Old,[F],New),
	flag(expansion_list,_,New).

del_expansion(F):-
	flag(expansion_list,Old),
	delete(Old,F,New),   % succeeds if it was not there..
	flag(expansion_list,_,New).

head_body((?- X0),query,X) :-
	prolog_conjunction(X0,X).
head_body((:- X0),fail,X) :-
	prolog_conjunction(X0,X).
head_body((H:-Body0),H,Body) :-
	!,
	prolog_conjunction(Body0,Body).
head_body(H,H,[]).

% term_expansion does findall(call_residue(series of expansion))

:- abolish(term_expansion/2).

te((?- Q),(?- Q)) :-
	!.
te(end_of_file,end_of_file) :-
	!.   % for now - it sometimes might be interesting to have it
te(Clause0,Clausesx) :-
	( flag(trace_exp,on) -> trace ; true ),
	head_body(Clause0,Head,Body),
	findall(Clause,constraints_expand(Head,Body,Clause),Clauses),
	( flag(write_exp,on) -> portrays(Clauses) ; true ),
	!,
	single_or_set(Clauses,Clausesx).
te(C,C).  % robustness

single_or_set([H],H) :-!.
single_or_set(L,L).

portrays([]).
portrays([H|T]) :-
	portray_clause(H),
	portrays(T).

constraints_expand(Head0,Body0,Clause) :-
	call_residue(expander(Head0,Body0,Head,Body1),Body2),
	rewrite_body(Body2,[],Body3,[]),
	append(Body3,Body1,Body4),
	build_clause(Head,Body4,Clause).

rewrite_body([],_,C,C).
rewrite_body([_-H|T],Other,C0,C):-
	eq_member(H,Other),
	!,
	rewrite_body(T,Other,C0,C).
rewrite_body([_-H|T],Other,[H|C0],C):-
	rewrite_body(T,[H|Other],C0,C).

eq_member(X,[Y|_]):-
	X==Y.
eq_member(X,[_|T]):-
	eq_member(X,T).

build_clause(query,Body0,(?-Body)) :-
	!,
	prolog_conjunction(Body,Body0).
build_clause(fail,Body0,(:-Body)) :-
	!,
	prolog_conjunction(Body,Body0).
build_clause(Head,true,Head) :- !.
build_clause(Head,Body0,(Head:-Body)) :-
	prolog_conjunction(Body,Body0).

expander(Head0,Body0,Head,Body) :-
	flag(expansion_list,Old),
	expander(Old,Head0,Body0,Head,Body).

expander([],H,B,H,B).
expander([F|T],H0,B0,H,B) :-
	expand_one(F,H0,B0,H1,B1),
	expander(T,H1,B1,H,B).

expand_one(F,H0,B0,H,B) :-
	if( expand_it(F,H0,B0,H,B),
            true,
            ( H0=H, B0=B )
	  ).

expand_it(F,H0,B0,H,B) :-
	is_mod(F,Module,Functor),
	Call =.. [Functor,H0,B0,H,B],
	call(Module:Call).

is_mod(F,user,F) :-
	atomic(F).
is_mod(Mod:F,Mod,F).


:- initialize_flag(expansion_list,[dcg_expansion]).

:- assertz((term_expansion(A,B) :- te(A,B))).

