% RESTRICT(+Term,+Depth,-RestrTerm)
%
% 
:- module(restrict,[restrict/3]).

restrict(Term,Depth,Restr):-
	integer(Depth),
	restrict(Term,0,Depth,Restr).

restrict(_,D,D,_):-
	!.
restrict(Term,_D0,_D,Restr):-
	var(Term),!,
	Term = Restr.
restrict(Term,D0,D,Restr):-
	functor(Term,F,A),
	functor(Restr,F,A),
	D1 is D0 + 1,
	restrict_args(0,A,Term,D1,D,Restr).

restrict_args(A,A,_,_,_,_):-
	!.
restrict_args(P0,A,Term,D1,D,Restr):-
	P is P0 + 1,
	arg(P,Term,TP),
	arg(P,Restr,RP),
	restrict(TP,D1,D,RP),
	restrict_args(P,A,Term,D1,D,Restr).






