proc SP_qbox {w lvar title text} {
    global answer
    upvar $lvar listvar

# adapted from sentence.tcl which is adapted from 
# question.tcl which itself is adapted from dialog.tcl

# 1. Create the top-level window and divide it into top
# and bottom parts.

    set answer {}
    catch {destroy $w}
    toplevel $w -class Dialog
    wm minsize $w 0 0
    wm title $w $title
    wm iconname $w Question
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both -expand 1
    entry $w.mid -relief sunken -bd 1 -textvariable answer -bg white
    pack $w.mid -side top -padx 3m -fill both -expand yes
    frame $w.frame
    pack $w.frame -side top -expand yes -fill y -fill x
    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both

    scrollbar $w.frame.scroll -relief sunken -command "$w.frame.list yview"
    scrollbar $w.frame.xscroll -relief sunken -command "$w.frame.list xview" \
           -orient horiz
    listbox $w.frame.list -yscroll "$w.frame.scroll set" -relief sunken \
      -geometry 70x10 -xscroll "$w.frame.xscroll set"

    pack $w.frame.xscroll -side bottom -fill x
    pack $w.frame.scroll -side right -fill y
    pack $w.frame.list -side left -expand yes -fill both

    eval $w.frame.list insert 0 $listvar

    bind $w.frame.list <Double-1> {
          set answer [join [selection get] " "] 
          set ready 1
          } 

    bind $w.mid <Return> {set ready 1}

    # 2. Fill the top part with message.

    message $w.msg -text $text -width 5i\
	-font -adobe-times-medium-r-normal-*-20-*-*-*-*-*-*-*
#	    -font -Adobe-Times-Medium-R-Normal-*-180-*
    pack $w.msg -in $w.top -side right -fill both -padx 1m -pady 1m -expand 1

    # 3. Create a row of buttons at the bottom of the dialog.

    button $w.button -text "Cancel" -command "set answer 0 ; set ready 1"
    pack $w.button -in $w.bot -side left -expand 1 \
           -padx 3m -pady 3m -ipadx 2m -ipady 1m

    # 4. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w

    # 5. Set a grab and claim the focus too.

    set oldFocus [focus]
    grab $w
    focus $w

    # 6. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.

    tkwait variable ready
    destroy $w
    focus $oldFocus
    if {$answer == 0} {return 0} 
    set listvar [linsert $listvar 0 $answer]
    return $answer
}
