%% link_clause.pl
%% a la R.O.Keefe
%% for predicates that are defined in multiple files
%%
%%

add_module(Pred0,M:Pred) :-
	( Pred0 = M:Pred -> true ; Pred0 = Pred, M=user ).

add_linking_clause(Link0,Pred0,Ar):-
	add_module(Link0,Ml:Link),
	add_module(Pred0,Mp:Pred),    % must be in user...
	make_goal(Pred,Ar,Head,Vars),
	make_goal(Link,Ar,Body,Vars),
	(  clause_exists(Mp,Head,Ml,Body,_Ref)
        -> true
	;  asserta(Mp:(Head :- Ml:Body))
	).

del_linking_clause(Link0,Pred0,Ar):-
	add_module(Link0,Ml:Link),
	add_module(Pred0,Mp:Pred),
	make_goal(Pred,Ar,Head,Vars),
	make_goal(Link,Ar,Body,Vars),
	( clause_exists(Mp,Head,Ml,Body,Ref),
	  erase(Ref),
	  fail
	; true
	).

clause_exists(user,Head,user,Body,Ref) :-
	!,
	clause(Head,Body,Ref).

clause_exists(HM,Head,BM,Body,Ref) :-
	!,
	clause(HM:Head,BM:Body,Ref).

make_goal(Pred,Ar,Head,Vars):-
	length(Vars,Ar),
	Head =.. [Pred|Vars].

add_portray(P) :-
	add_linking_clause(P,portray,1).

del_portray(P) :-
	del_linking_clause(P,portray,1).

