:- module(flags, [
            initialize_flag/2,
            flag/2,
            flag/3,
            wr_flag/1,
            wr_flag/2,
            member_flag/2,
            add_flag/2,
            del_flag/2
		 ]).

:- use_module( library(lists), [ member/2,
	                         select/3 ] ).

% setting/reading global variables that have a single value
% with flag/2,3

% setting/reading flags with more than one value
% with add_flag/2,del_flag/2,member_flag/2

% sets flag to Val only if Flag is currently undefined
% this is useful to have in as file directives; once such
% files are reconsulted in e.g. a debugging session, these
% variables are not touched
initialize_flag(Flag,Val) :-
	flag(Flag,Old),
	(  Old = undefined    % if undefined 
	-> flag(Flag,_,Val)   % change it
	;  true ).            % else don't

flag(Flag,Val):-              % to read Val of variable Flag
    flag(Flag,Val,Val).

flag(Flag,Old,New):-          % to set Flag from Old to New value
	nonvar(Flag),
	( recorded(Flag, '$flag'(Flag,Old), Ref)
	; Old = undefined
	),
	( Old == New
	; ( var(Ref)
	  ; erase(Ref)
	  ),
	  recorda(Flag, '$flag'(Flag,New),_)
	),!.

wr_flag(A):-
	wr_flag(A,_V).

wr_flag(A,V):-
	flag(A,V),
	print(A=V),
	nl.

member_flag(Flag,Val):-
	flag(Flag,List),
	member(Val,List).

% add Val as one of the values for Flag
add_flag(Flag,Val):-
	flag(Flag,OldL),
	(  member(Val,OldL)
	-> OldL = NewL
	;  NewL = [Val|OldL]
	),
	flag(Flag,OldL,NewL).

% delete Val as one of the values for Flag
del_flag(Flag,Val):-
	flag(Flag,OldL),
	(  select(Val,OldL,NewL)
	;  OldL = NewL
	),!,
	flag(Flag,OldL,NewL).


