%%%% file: feature.pl
%%%%
%%%% TYPES: a la HPSG, but implemented a la P-PATR and C. Mellish

%%%% Formally different from HPSG type system, but seems powerful enough
%%%% to implement most of the HPSG linguistics --- except for the
%%%% truly recursive uses (append)

:- module(feature,['=>'/2,
                   '<=>'/2,
                   '==>'/2,
		   '=*>'/2,
		   unify_except/3,
		   unify_except_type/3,
		   unify_except_l/3,
		   find_type/2,
		   find_type/3,
		   overwrite/4,
		   subtype/3,
		   type_compiler/0,
		   eval_funct/2,
		   % inherit from p_feature:
		   pretty/1,
		   tty_fs/1,
		   tty_fs_clause/1,
		   tty_fs_listing/1,

		   % inherit from c_feature:
		   % change/6
                   % change_pretty_constraints/4

		   % inherit from p_type:
		   pretty_type/1,
		   pretty_type_graphic/1,
		   pretty_type_gm/1,
		   pretty_type_tk/1,
		   pretty_type_latex/1,

		   type_graphic_path/3,
		   type_graphic_label/3,
		   type_graphic_daughter/4,

		   % inherit from mellish:
		   compile_boolean_types/0,
	           eval_b_type/2,
		   give_boolean_type/2
	          ]).


:- ensure_loaded([
                  library('f/feature'),
                  library('f/mellish'),
	          library('f/p_feature'),
		  library('f/c_feature'),
		  library('f/p_type')
	         ]).

