:- use_module(library(lists), [ nth/3 ]).
:- use_module(library(concat),[ concat_all/3 ]).

pretty_type(T) :-
	pretty_type_one(T,0),
	nl.

pretty_type_conj([],_).

pretty_type_conj([H],Tab) :-
	!,
	pretty_type_disj(H,Tab).

pretty_type_conj([H|T],Tab) :-
	nl,
	tab(Tab),
	write('{'),
	pretty_type_disj(H,Tab),
	pretty_type_conj2(T,Tab),
	nl,
	tab(Tab),
	write('}').

pretty_type_conj2([],_).
pretty_type_conj2([H|T],Tab):-
	nl,
	tab(Tab),
	write(and),
	pretty_type_disj(H,Tab),
	pretty_type_conj2(T,Tab).

pretty_type_disj([],_).

pretty_type_disj([H],Tab) :-
	!,
	pretty_type_one(H,Tab).

pretty_type_disj([H|T],Tab) :-
	nl,
	tab(Tab),
	write('{'),
	pretty_type_one(H,Tab),
	pretty_type_disj2(T,Tab),
	nl,
	tab(Tab),
	write('}').

pretty_type_disj2([],_).
pretty_type_disj2([H|T],Tab):-
	write(' OR '),
	pretty_type_one(H,Tab),
	pretty_type_disj2(T,Tab).

pretty_type_one(H,Tab):-
	define_type(H,List,Atts,_,_),
	nl,
	tab(Tab),
	write_type(H),
	write_atts(Atts),
	Tab2 is Tab + 5,
	pretty_type_conj(List,Tab2).

write_type(Type):-
	write(Type).

write_atts([]):-!.
write_atts(Atts):-
	concat_all(Atts,A,' '),
	tab(1),
	write('<'),
	write(A),
	write('>').

% only makes sense if modules are loaded
pretty_type_gm(T) :-
	gm_tree:gm_tree(type,T).

pretty_type_graphic(T) :-
	p_tree:pretty_graphic(type,T).  

pretty_type_latex(T) :-
	p_tree:tree_def_to_tree(type,T,Tree),
	latex:latex_tree(Tree).

pretty_type_tk(T) :-
	tk_tree:tk_tree(type,T).

:- user:del_linking_clause(feature:type_graphic_path,graphic_path,3),
   user:del_linking_clause(feature:type_graphic_label,graphic_label,3),
   user:del_linking_clause(feature:type_graphic_daughter,graphic_daughter,4).


type_graphic_path(type,T,T).


type_graphic_label(type,T,Label):-
	define_type(T,_,[H|Tail],_,_),
	concat_all([T,':',H|Tail],Label,' ').
type_graphic_label(type,T,T):-
	define_type(T,_,[],_,_).
type_graphic_label(type,[_H|_T],and).


type_graphic_daughter(type,I,T,Val):-
	define_type(T,[V],_,_,_),
	!,
	nth(I,V,Val).
type_graphic_daughter(type,I,T,V):-
	define_type(T,Subs,_,_,_),
	nth(I,Subs,V).

type_graphic_daughter(type,I,[H|T],V):-
	nth(I,[H|T],V).

:- user:add_linking_clause(feature:type_graphic_path,graphic_path,3),
   user:add_linking_clause(feature:type_graphic_label,graphic_label,3),
   user:add_linking_clause(feature:type_graphic_daughter,graphic_daughter,4).


%% uses library(command)).

:- user:del_command(feature:p_type_cmd).

p_type_cmd(feature:pretty_type(Type)) -->
        [type],
        [Type],
        { feature:define_type(Type,_,_,_,_) }.

p_type_cmd(feature:pretty_type(top)) -->
        [type].

p_type_cmd(feature:pretty_type_graphic(Type)) -->
        [gtype],
        [Type],
        { feature:define_type(Type,_,_,_,_) }.

p_type_cmd(feature:pretty_type_graphic(top)) -->
        [gtype].

p_type_cmd(feature:pretty_type_gm(Type)) -->
        [gmtype],
        [Type],
        { feature:define_type(Type,_,_,_,_) }.

p_type_cmd(feature:pretty_type_gm(top)) -->
        [gmtype].

p_type_cmd(feature:pretty_type_latex(Type)) -->
        [xtype],
        [Type],
        { feature:define_type(Type,_,_,_,_) }.

p_type_cmd(feature:pretty_type_latex(top)) -->
        [xtype].

:- user:add_command(feature:p_type_cmd).


