%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                         %
% written by Gertjan van Noord                            %
% (C) 1989,1990,1991,1992,1993                            %
%                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- use_module( library(lists), [ member/2 ]).

change_pretty_constraints([],[],_,_).
change_pretty_constraints([H|T],[NH|NT],In,InNo) :-
	change_pretty_constraint(H,NH,In,In2,InNo,InNo2),
	change_pretty_constraints(T,NT,In2,InNo2).

change_pretty_constraint(_Module:H,NH,In0,In,InNo0,InNo) :-
	!,
	change_pretty_constraint(H,NH,In0,In,InNo0,InNo).

change_pretty_constraint(when(_,H),NH,In0,In,InNo0,InNo) :-
	!,
	change_pretty_constraint(H,NH,In0,In,InNo0,InNo).

change_pretty_constraint(H,NH,In0,In,InNo0,InNo) :-
	H =.. [F|Args],
	change_pretty_arguments(Args,NArgs,In0,In,InNo0,InNo),
	NH =.. [F|NArgs].

change_pretty_arguments([],[],C,C,I,I).
change_pretty_arguments([H|T],[NH|NT],C0,C,I0,I):-
	change(H,NH,C0,C1,I0,I1),
	change_pretty_arguments(T,NT,C1,C,I1,I).

%%%%%%%%%%%%%%%%
% change does some things in parallel:
%  - find out about reentrancies: only first occurrence is printed
%    ( variables are only printed if there are being referred to)
%  - change datastructure back into something with explicit attributes etc.

change(Term1,Term2,InHis,OutHis,InNo,OutNo):-
	change(Term1,Term2,InHis,OutHis,InNo,OutNo,root).

% Atomic
% Integer/YesNo = Term
% Integer is some index
% YesNo if yes then it is an index which some other substructure refers to
% Term is a term, or special symbol 'R' when it should be skipped because
% already printed...

intensional(Term) :-
	\+ atomic(Term).

intensional(Term) :-
	find_type(Term,[T|_]),
	\+ user:extensional(T).

% case 1: anonymous var
change('$VAR'('_'),_/n='$VAR'('_'),H,H,I,I,_) :-
	!.

%case 2: term is already there somewhere in history
change(Term1,P/y='R',HisList,HisList,I,I,_):-
	intensional(Term1),
%%	\+ Term1 = [],   % empty lists are not intensional
	member(P/y=Term1,HisList),!.

%case 3: term is not there but of type '$VAR'
% in that case there is some substructure referring to it, otherwise
% catched by case 1! However, this substructure could be dominated by something
% that already takes care of coindexing...
change('$VAR'(No),No/Y='$VAR'(No),Out,[No/Y='$VAR'(No)|Out],J,J,_) :-
	!.

%case 4: term is not there yet

change(T1,I/Y=[a(type,Types)|T2],H0,H,I,J,_):-
	find_type(T1,Types0,Atts),
	change_type(Types0,Types,[I/Y=T1|H0],H1),
	I2 is I + 1,
	change_ts(Atts,T1,T2,H1,H,I2,J),!.

change_type([Type0],[Type],H0,H) :-
	!,
	functor(Type0,F,Ar),
	functor(Type,F,Ar),
	change_term(Ar,Type0,Type,H0,H).
change_type(Types0,Types,H0,H) :-
	change_term(Types0,Types,H0,H).


% case 5: boolean type
change(Term,I/_Y=[a('BOOLEAN',Type,Term)],H,H,I,I,_):-
	functor(Term,Type,_),
	user:boolean_type(Type,_).

% case 6 TREES
change(tree(Cat,Mark,Ds),I/_Y=[a('TREE',Mark,Cat2,Ds2)],HI,HO,I,J,_Att):-
	!,
	I2 is I+1,
	change(Cat,Cat2,HI,H2,I2,I3,root),
	change_l(Ds,Ds2,H2,HO,I3,J,root).

change(lex(X),lex(X),H,H,I,I,_) :-
	!.

% case 7: UNTYPED!!:
change(Term0,I/_Y=[a('UNTYPED',Att,Term)],H0,H,I,I,Att) :-
	change_term(Term0,Term,H0,H).

% case 1: anonymous var
change_term('$VAR'('_'),'$VAR'('_'),H,H) :-
	!.
% case 2: thing has been printed already
change_term(Term,'$VAR'(P),H,H) :-
	\+ atomic(Term),
	member(P/y=Term,H),
	!.
% case 3 term not there yet but non-anonymous var
change_term('$VAR'(No),'$VAR'(No),Out,[No/_Yes = '$VAR'(No)|Out]) :-
	!.
% case 4 term not there yet: go down recursively
change_term(Term0,Term,H0,H) :-
	functor(Term0,F,Ar),
	functor(Term,F,Ar),
	change_term(Ar,Term0,Term,H0,H).

change_term(0,_,_,H,H) :-
	!.
change_term(I0,T0,T,H0,H) :-
	arg(I0,T0,A0),
	arg(I0,T,A),
	change_term(A0,A,H0,H1),
	I is I0 - 1,
	change_term(I,T0,T,H1,H).

change_l([],[],H,H,I,I,_).
change_l([H|T],[H2|T2],HI,HO,I,J,A):-
	change(H,H2,HI,Ho,I,I2,A),
	change_l(T,T2,Ho,HO,I2,J,A).

change_l('$VAR'(X),'$VAR'(X),H,H,I,I,_).

% change/7:
change_ts([],_T1,[],H,H,I,I).
change_ts([H|T],T1,[a(H,V2)|R],H1,HO,I,O):-
        e(H,T1,V1),
	change(V1,V2,H1,H2,I,I2,H),
        change_ts(T,T1,R,H2,HO,I2,O).






