%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                         %
% written by Gertjan van Noord                            %
% (C) 1989                                                %
%                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% equivalent
%
%
% defines predicate equal(A,B) to test whether two
% terms are alphabetic variants
%
% seems to be faster than double subsumption check!
% May not be true for Prologs with built-in subsumption check
%
% works with coinstantiated variables between A and B
% whereas double subsumption check does not..!

:- module(equi,[equal/2]).

equal(A,B) :-
    \+ \+ A = B,       % cheap test to see whether it is worth trying
    equal(A,B,[],_).

equal(A,B,In,Out):-
    var(A),
    !,
    var(B),
    equal_member(In,A,B,Out).

% the next one is not neccessary because functor will fail in next clause
% anyway - yes it is for YAP and Sicstus 2.1
equal(_,Var,_,_):-
    var(Var),
    !,
    fail.

equal(A,B,Subst,Final):-
    functor(B,F,N),  % this one first to fail if variable
    functor(A,F,N),
    equal(N,A,B,Subst,Final).

equal(0,_,_,S,S):-
    !.

equal(N,A,B,In,Out):-
    arg(N,A,An),
    arg(N,B,Bn),
    equal(An,Bn,In,Mid),
    M is N - 1,
    equal(M,A,B,Mid,Out).


% equal_member(+List,VarA,VarB,-List2)
equal_member([],A,B,[A=B]):-
    !.
equal_member([A2=B2|T],A,B,[A2=B2|T]):-
    A == A2,
    !,
    B == B2.
equal_member([A2=B2|T],A,B,[A2=B2|T]):-
    B == B2,
    !,
    A == A2.
equal_member([H|T],A,B,[H|T2]):-
    equal_member(T,A,B,T2).






