:- module(env, [ get_env_var/2 ]).

:- use_module(library(concat)).
:- use_module(library(lists)).
:- use_module(library(charsio)).

% get_env_var(+EnvVar,-Value)
stream_to_chars(Stream,C0,C) :-
	peek_char(Stream,Next),
	stream_to_chars(Next,Stream,C0,C).

% note: final return is cut off.
stream_to_chars(-1,_,C,C) :- !.
stream_to_chars(10,Stream,C0,C):-
	!,
	get0(Stream,_),
	peek_char(Stream,Char),
	stream_to_chars1(Char,Stream,C0,C).
stream_to_chars(Char,Stream,[Char|C0],C) :-
	get0(Stream,_),
	peek_char(Stream,Next),
	stream_to_chars(Next,Stream,C0,C).

stream_to_chars1(-1,_,C,C) :-!.
stream_to_chars1(Char,Stream,[10,Char|C0],C) :-
	get0(Stream,_),
	peek_char(Stream,Next),
	stream_to_chars(Next,Stream,C0,C).

get_env_var(Var,Val) :-
	cached(Var,Val),!.

get_env_var(Var,Val) :-
	concat_all(['echo $',Var],Cmd),
	unix(popen(Cmd,read,Stream)),
	stream_to_chars(Stream,Chars,[39,46]),
	read_from_chars([39|Chars],Val),
	\+ Val = '',
	assert(cached(Var,Val)).



	


