:- module(bug_c,[]).
:- ensure_loaded(library(flags)).
:- add_flag(generator_mode,bug_c).

:- use_module(library(lists),[append/3]).

%%%%%%%%%%%%%%%
%% GENERATOR %%
%%%%%%%%%%%%%%%

clean.
count.
count(0).

generate(o(Obj,Str,_)):-
	user:deriv_tree(Obj,Tree),
	bug(Obj,Str,[],Tree).

bug(Node,P0,P,Tree) :-
	user:semantics(Node,Sem),
	bug(Sem,Node,P0,P,Tree).

:- block bug(-,?,?,?,?).

bug(Sem,Node,P0,P,Tree) :-
	user:size(Sem,Size),
	predict_headg(Node,SmallNode,Q0,Q,SmallTree),
	connectg(SmallNode,Node,Size,Q0,Q,P0,P,SmallTree,Tree).

connectg(X,X,_,P0,P,P0,P,Tree,Tree).
connectg(SmallNode,Node,Size0,P1,P2,Q0,Q,Small,Tree):-
  	user:h_rule(SmallNode,MidNode,Left,Right,Rule),
	bugl(Left,P0,P1,Size0,Size1,[Small|Rtrees],Trees),
	bugr(Right,P2,P,Size1,Size2,Rtrees),
	connectg(MidNode,Node,Size2,P0,P,Q0,Q,tree(Rule,_,Trees),Tree).

bugr([],P,P,S,S,[]).
bugr([H|T],P0,P,S0,S,[Ht|Tt]) :-
	S0 > 0,
	bug(H,P0,P1,Ht),
	S1 is S0 - 1,
	bugr(T,P1,P,S1,S,Tt).

bugl([],P,P,S,S,T,T).
bugl([H|T],P0,P,S0,S,T0,Tt) :-
	S0 > 0,
	bug(H,P1,P,Ht),
	S1 is S0 - 1,
	bugl(T,P0,P1,S1,S,[Ht|T0],Tt).

predict_headg(Node,SmallNode,P0,P,tree(Rule,_,[])):-
	user:semantics(Node,Sem),
	user:semantics(SmallNode,Sem),
	user:hfc(SmallNode,Node),
	user:lexicon(Words,SmallNode,Rule),
	append(Words,P,P0).




