:- ensure_loaded(ops).

:- ensure_loaded(compilation). 

:- ensure_loaded([ 'PG/hc_ch', 
                   'PG/hc_mp',
		   'PG/hc_mmp',
	           'PG/hc',
                   'PG/lc_ch',
		   'PG/left_ch',
		   'PG/head_ch',
		   'PG/right_ch'
 ]).

:- ensure_loaded([ 'PG/bug_wf',
                   'PG/bug']).

:- ensure_loaded(d), compile_rules.

:- use_module( library(flags) ).

:- initialize_flag(parser,hc_mp).
:- initialize_flag(top_features,main).
:- initialize_flag(generator,bug_wf).

:- version('Grammar based on the paper: 
An overview of Head-driven Generation').

gram_dir(Path) :-
	source_file(gram_dir(_),File),
	concat(Path,'start.pl',File).

gram_startup_hook_end :-
	gram_dir(Path),
	concat(Path,'gb.tcl',File),
	concat('source ',File,Cmd),
	tcl_eval(Cmd).

:- ensure_loaded(suite).
