compile_grammar :-
	compile(gram).

reconsult_grammar :-
	reconsult(gram).

compile_grammar_file(File) :-
	compile(File).

reconsutl_grammar_file(File) :-
	reconsult(File).

:- initialize_flag(top_features,s).

:- initialize_flag(parser,gram).
:- initialize_flag(generator,gram).

:- version('Simple DCG').

:- compile_grammar.

top(s,'/'(s,_,_,_)).

:- prolog_flag(redefine_warnings,_,off).

start_parse_hook(_,_).

:- prolog_flag(redefine_warnings,_,on).

extern_sem([S],S).

phonology('/'(_,_,P0,[]),P0).

semantics('/'(_,Sem,_,_),Sem).

gram_dir(Path) :-
	source_file(gram_dir(_),File),
	concat(Path,'start.pl',File).

gram_startup_hook_end :-
	gram_dir(Path),
	concat(Path,'dcg.tcl',File),
	concat('source ',File,Cmd),
	tcl_eval(Cmd).

:- del_graphic(gp,gl,gd).

gp(s,'/'(_,S,_,_),S).

gl(s,Term,Label) :-
	functor(Term,Label,_).

gd(s,1,Term,D) :-
	arg(1,Term,D).

gd(s,2,Term,D) :-
	arg(2,Term,D).

:- add_graphic(gp,gl,gd).

:- ensure_loaded(suite).
