%%%%%%%%%%%%%%%%%%%%%%%%%%%% examples %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- dynamic ex_index/1, example/3.

create_examples(FN) :-
	retractall(ex_index(_)),
	retractall(example(_,_,_)),
	process_examples,
	tell(FN),
	listing(example/3),
	told.
	
/*
process_examples :-
	ex(Sentence),
	findall(_N,( parse(Sentence,[],t(Sign,_Ds)),
		    startsymbol(Sign)
		  ),Ns),
	length(Ns,Analyses),
	assert_ex(Analyses,Sentence),
	fail.
process_examples.
*/
process_examples :-
	ex(Sentence),
	analyze(Sentence,Trees),
	length(Trees,Analyses),
	assert_ex(Analyses,Sentence),
	fail.
process_examples.

analyze(Sentence,Trees) :-			% analyze using cf methods
	retractall(item(_,_,_,_)), 
	retractall(index_item(_,_,_,_,_,_)),
	scan(Sentence,0,End),
	findall(t(Sign,Ds), ( 	startsymbol(Sign),
				recover(t(Sign,Ds),_,0,End)
		      	    ),
		Trees),
	!.
	
assert_ex(Analyses,Sentence) :-
	( retract(ex_index(N)) -> 
	  N1 is N + 1
	; N1 = 1
	),
	assert(ex_index(N1)),
	assertz(example(N1,Analyses,Sentence)),
	write(example(N1,Analyses,Sentence)), nl, ttyflush, !.

%%%%%%%%%%%%%%%%% examples collection	

%% basics (main and subordinate clauses, relatives, questions)

ex([jan, slaapt ]).
ex([de, mannen, uit, groningen, slapen ]).
ex([jan, kust, marie ]).
ex([de, man, die, slaapt, kust, marie ]).
ex([de, man, van, wie, marie, houdt, slaapt ]).
ex([de, vrouw, wiens, broer, ik, ken, slaapt ]).
ex([wie, denk, ik, dat, marie, kust ]).


%% vraising, extraposition, and partial extraposition
%% subordinate clauses (probeert is ambiguous)

ex([ik, denk, dat, hij, marie, wil, kussen ]).
ex([ik, denk, dat, hij, wil, marie, kussen ]).
ex([ik, denk, dat, hij, jan, marie, ziet, kussen]).

ex([ik, denk, dat, hij, marie, vraagt, het, boek, te, lezen ]).
ex([ik, denk, dat, hij, marie, het, boek, vraagt, te, lezen ]).
ex([ik, denk, dat, hij, verzuimt, marie, te, kussen ]).
ex([ik, denk, dat, hij, marie, verzuimt, te, kussen ]).
ex([ik, denk, dat, hij, probeert, marie, te, kussen ]).
ex([ik, denk, dat, hij, marie, probeert, te, kussen ]).


%% phrasal and subphrasal constituents

ex([ik, denk, dat, hij, marie, heeft, willen, kussen ]).
ex([ik, denk, dat, hij, marie, schijnt, op, te, bellen ]).
ex([ik, denk, dat, hij, marie, heeft, willen, op,  bellen ]).
ex([ik, denk, dat, hij, marie, heeft, op, willen, bellen ]).
ex([ik, denk, dat, hij, marie, op, heeft, willen, bellen ]).
ex([ik, denk, dat, hij, marie, heeft, gevraagd, het, boek, te, lezen ]).
ex([ik, denk, dat, hij, marie, heeft, geprobeerd, te, kussen ]).
ex([ik, denk, dat, hij, marie, heeft, proberen, te, kussen ]).


%% participle inversion 

ex([ik, denk, dat, hij, marie, heeft, gekust]).
ex([ik, denk, dat, hij, marie, gekust, heeft ]).
ex([ik, denk, dat, hij, van, marie, gehouden, moet, hebben ]).
ex([ik, denk, dat, hij, van, marie, moet, gehouden, hebben ]).

%% oke with extraposition, but not with vr verbs

ex([ik, denk, dat, jan, hem, gevraagd, heeft, marie, op, te, bellen ]).
ex([ik, denk, dat, hij, marie, willen, heeft, op, bellen ]).

%% modal inversion, only with finite modals, complement must be -vr

ex([ik, denk, dat, hij, marie, kussen, wil ]).
ex([ik, denk, dat, hij, marie, kussen, heeft, willen ]).
ex([ik, denk, dat, jan, hem, vragen, wil, marie, te, kussen ]).
ex([ik, denk, dat, hij, marie, hebben, wil, gekust ]).

%% the scope of adjuncts

ex([ik, denk, dat, jan, marie, mogelijk, kussen, wil ]).
ex([ik, denk, dat, jan, altijd, een, meisje, kussen, wil ]).
ex([ik, denk, dat, altijd, een, jongen, haar, kussen, wil ]). 

%% adjunct topicalization (spurious ambiguities arising from interaction of
%% extraction-lr, add-adjuncts rule, and division)

ex([nooit, hoor, ik, marie, zingen ]).

%% vp topicalization (spurious ambiguities arising from interaction of v1/v2 and
%% inversion

ex([kussen, wil, jan, marie ]).
ex([marie, kussen, wil, jan ]).
ex([willen, kussen, heeft, jan, marie ]).
ex([willen, heeft, jan, marie, kussen ]).




