
;;===========================================================================
;; System Definition for NEITHER
;;
;; -------------------------------------------------------------------------
;; authors: Paul T. Baffes.
;; Copyright (c) 1992 by AUTHORS. This program may be freely copied, used,
;; or modified provided that this copyright notice is included in each copy
;; of this code and parts thereof. 
;; -------------------------------------------------------------------------
;;
;; This file is the system definition for NEITHER. Currently, it works with
;; two different systems: lucid common lisp on the SPARCS and Allegro common
;; lisp on the Macintosh.
;;
;; If you port the code to your own local system, this system definition
;; should :-) work just fine as long as you redefine the two parameters at
;; the top of the file which indicate where the source code directories are.
;;
;; CHANGE HISTORY
;; 
;; 12-MAR-93 (ptb): modified the defsystem to include the "model.lisp" code
;;           for generating student models. This is not essential for running
;;           NEITHER, but it won't hurt it. At some point, I should make this
;;           something that is only loaded when using NEITHER with ASSERT (a
;;           different program that uses NEITHER as one of its components).
;;===========================================================================

(in-package #+:cltl2 "CL-USER" #-:cltl2 "USER")


;;---------------------------------------------------------------------------
;; Below are two parameters that define where the source code directories
;; are. One is for NEITHER's source code, the other is for the defsystem
;; source code.
;;---------------------------------------------------------------------------

(defparameter *neither-dir*
  #+:ccl"hardisk:thesis:neither:source"
  #-:ccl"/u/baffes/neither"
  )

(defparameter *defsystem-dir*
  #+:ccl"hardisk:thesis:neither:defsys"
  #-:ccl"/u/baffes/neither"
  )


;;---------------------------------------------------------------------------
;; Load the defsystem code from the appropriate directory, using the
;; parameter defined above and assuming that the defsystem source code name
;; is "defsystem.lisp"
;;---------------------------------------------------------------------------

#-:mk-defsystem
(load #+:ccl(format nil "~a:mcl-defsystem.lisp" *defsystem-dir*)
      #-:ccl(format nil "~a/mcl-defsystem.lisp" *defsystem-dir*)
      )


;;---------------------------------------------------------------------------
;; System definition for NEITHER
;;---------------------------------------------------------------------------

(defsystem neither
    :source-pathname     #+:ccl(format nil "~a:" *neither-dir*)
                         #-:ccl(format nil "~a/" *neither-dir*)
    :source-extension    "lisp"
    :components ((:module neither-structs
			  :source-pathname ""
                          :components (#+(and :ccl (not :mcl)) (:file "loop")
				       (:file "structures")
				       (:file "data-utilities")
				       ;;(:file "id3")
				       (:file "pfoil")
				       ))
		 (:module neither-code
			  :source-pathname ""
			  :components ((:file "debug")
				       (:file "deduce")
				       (:file "abduce")
				       (:file "rule-retract")
				       (:file "io")
				       (:file "label")
				       ;;(:file "id3-glue")
				       (:file "pfoil-glue")
				       (:file "induce")
				       (:file "subset")
				       (:file "generalize")
				       (:file "specialize")
				       (:file "model")
				       (:file "neither")
				       )
			  :depends-on ("neither-structs"))))



(defun load-neither (&key (verbose t) (dont-compile nil))
  ;;-------------------------------------------------------------------------
  ;; Recompiles whatever source code files have been updated and loads those
  ;; new binaries into the lisp environment.
  ;;-------------------------------------------------------------------------
  #+:ccl(let ((*warn-if-redefine-kernel* nil))
          (if dont-compile
            (operate-on-system 'neither 'load :verbose verbose)
	    (operate-on-system 'neither 'compile :verbose verbose
			       :force :new-source-and-dependents)))
  #-:ccl(with-deferred-warnings
          (if dont-compile
            (operate-on-system 'neither 'load :verbose verbose)
	    (operate-on-system 'neither 'compile :verbose verbose
			       :force :new-source-and-dependents)))
  (unless (member ':neither *features*) (push ':neither *features*))
  )


(defun compile-neither (&key (verbose t))
  ;;-------------------------------------------------------------------------
  ;; Forces a recompilation of all NEITHER files and loads the new binaries
  ;; into the lisp environment.
  ;;-------------------------------------------------------------------------
  #+:ccl(let ((*warn-if-redefine-kernel* nil))
	  (operate-on-system 'neither 'compile :verbose verbose :force :all))
  #-:ccl(with-deferred-warnings
          (operate-on-system 'neither 'compile :verbose verbose :force :all))
  (unless (member ':neither *features*) (push ':neither *features*))
  )


;;---------------------------------------------------------------------------
;; Finally, insert a call to load-neither to get the neither code loaded into
;; the system.
;;---------------------------------------------------------------------------
(load-neither)
