
;; DDKB (Domain Dependent Knowledge Base)
;; for puzzles with no functions and
;; only EQuality and iNEquality predicates.

(in-package "USER")

;; true iff EXP-1 is equal to EXP-2 in the P-LIST
(defun test-EQ (exp-1 exp-2 p-list)
  (or (eq (car exp-1) (car exp-2))
      (go-thru-eqs 'EQ (car exp-1) (car exp-2) p-list)))

;; true iff EXP-1 is NOT equal to EXP-2 in the P-LIST
(defun test-NE (exp-1 exp-2 p-list)
  (go-thru-eqs 'NE (car exp-1) (car exp-2) p-list))
  
;; Since NO special FUNCTIONS are involved, there is no need for simplification
(defun simplify (exp p-list)
  exp)

