;;; -*- Package: User; Syntax: Common-Lisp; Mode: Lisp; Base: 10. -*-

;;; File converted on 20-Jul-88 17:22:57 from source TLDEMOS
;;; Original source TLDEMOS.;3 created 18-Mar-87 17:44:25
;;; on {FireFS:CS:Univ Rochester}<Koomen>TimeLogic>FALL86>

;;; Copyright (c) 1986, 1987, 1988 by Johannes A. G. M. Koomen.
;;; All rights reserved.

(use-package 'TimeLogic)

(export '(tl-demo))

(defmacro catch-demo-aborts (&rest forms)
#+xerox
  `(il:nlsetq ,@forms)
#+explorer
  `(condition-case () (progn ,@forms) (sys:abort))
#+symbolics
  `(catch-error-restart (sys:abort "Go on to next demo") ,@forms)
#-(or xerox explorer symbolics)
  `(progn ,@forms)
)

(defun tl-demo ()
   (unless tl::*tl-display-initialized-flg* (tl::tl-init-display))
   (format t "~3&Simple demo of TimeLogic: cooking-dining-dishes~%   ")
   (if (y-or-n-p "Now? ")
       (catch-demo-aborts (tl-demo0)))
   (format t "~3&Switching the top two blocks on a stack -- verbose,dispay,wait,sort~%   ")
   (if (y-or-n-p "Now? ")
       (catch-demo-aborts (tl-demo1)))
   (format t "~3&Switching the top two blocks on a stack -- trace,display,wait 2~%   ")
   (if (y-or-n-p "Now? ")
       (catch-demo-aborts (tl-demo2)))
   (format t "~3&Switching the top two blocks on a stack -- notrace,nodisplay,nowait~%   ")
   (if (y-or-n-p "Now? ")
       (catch-demo-aborts (tl-demo3)))
   'Done
)


(defun tl-demo0 ()
   (tl::tl-clear-display)
   (timelogic-init)
   (timelogic-prop :trace :verbose)
   (timelogic-prop :display :on)
   (timelogic-prop :wait :on)
   (timelogic-prop :sort :on)

   (defintq cooking cook-demo)
   (defintq dining cook-demo)
   (defintq dishes cook-demo)
   (addintconq cooking :dur cook-demo)
   (addintconq dining :dur cook-demo)
   (addintconq dishes :dur cook-demo)

   (addintconq cooking :m dining)
   (addintconq dining :m dishes)
)


(defun tl-demo1 ()
   (tl::tl-clear-display)
   (timelogic-init)
   (timelogic-prop :trace :verbose)
   (timelogic-prop :display :on)
   (timelogic-prop :wait :on)
   (timelogic-prop :sort :on)
   (tl-demo-stack-switch)
)


(defun tl-demo2 ()
   (tl::tl-clear-display)
   (timelogic-init)
   (timelogic-prop :trace :on)
   (timelogic-prop :display :on)
   (timelogic-prop :wait 2)
   (timelogic-prop :sort :off)
   (trace-interval '(stack-demo i Oba Oac Obc
                               Oab g Oby Mbcy
                               Mbca PUba Hb PDbc
                               Oaz Mabz Mabc PUac
                               Ha PDab))
   (tl-demo-stack-switch)
   (addintconq i :dur stack-demo)
   (addintconq g :dur stack-demo)
   (display-intervals '(stack-demo i Oba Oac
                                  Obc Oab g Oby
                                  Mbcy Mbca PUba Hb
                                  PDbc Oaz Mabz
                                  Mabc PUac Ha PDab))
)


(defun tl-demo3 ()
   (tl::tl-clear-display)
   (timelogic-init)
   (timelogic-prop :trace :off)
   (timelogic-prop :display :off)
   (timelogic-prop :wait :off)
   (timelogic-prop :sort :off)
   (timelogic-prop :stats :reset)
   (tl-demo-stack-switch)
   (addintconq i :dur stack-demo)
   (addintconq g :dur stack-demo)
   (display-intervals '(stack-demo i Oba Oac
                                  Obc Oab g Oby
                                  Mbcy Mbca PUba Hb
                                  PDbc Oaz Mabz
                                  Mabc PUac Ha PDab))
   (timelogic-stats)
)

(defun tl-demo-stack-switch NIL
  ;; Switch top two blocks on stack (cf. Allen & Koomen, IJCAI-83)
  (TimeLogic-Init)
  (Define-Interval 'I 'stack-demo)
  (Define-Interval 'G 'stack-demo)
  (Add-Interval-Constraint 'I :S 'stack-demo)
  (Add-Interval-Constraint 'G :F 'stack-demo)
  (Add-Interval-Constraint 'I :B 'G)
  (Define-Interval 'Oba 'stack-demo)
  (Define-Interval 'Oac 'stack-demo)
  (Define-Interval 'Cb1 'stack-demo)
  (Add-Interval-Constraint 'Oba :Con 'I)
  (Add-Interval-Constraint 'Oac :Con 'I)
  (Add-Interval-Constraint 'Cb1 :Con 'I)
  (Define-Interval 'Oab 'stack-demo)
  (Add-Interval-Constraint 'Oab :Dis 'Oac)
  (Add-Interval-Constraint 'Cb1 :Dis 'Oab)
  (Add-Interval-Constraint 'Cb1 :Dis 'Oab)
  (Define-Interval 'Obc 'stack-demo)
  (Add-Interval-Constraint 'Obc :Dis 'Oac)
  (Add-Interval-Constraint 'Obc :Dis 'Oba)
  (Define-Interval 'Ca1 'stack-demo)
  (Add-Interval-Constraint 'Ca1 :Dis 'Oba)
  (Add-Interval-Constraint 'Oab :Con 'G)
  (Add-Interval-Constraint 'Obc :Con 'G)
  (Add-Interval-Constraint 'Ca1 :Con 'G)
  (Define-Interval 'Mabz 'stack-demo)
  (Add-Interval-Constraint 'Mabz '(:A :Mi) 'I)
  (Add-Interval-Constraint 'Mabz '(:B :M) 'G)
  (Define-Interval 'Ca2 'stack-demo)
  (Add-Interval-Constraint 'Ca2 '(:A :B :E) 'Ca1)
  (Add-Interval-Constraint 'Ca2 :Dis 'Oba)
  (Add-Interval-Constraint 'Mabz :Mi 'Ca2)
  (Define-Interval 'Oaz 'stack-demo)
  (Add-Interval-Constraint 'Mabz :Oi 'Oaz)
  (Define-Interval 'Cb2 'stack-demo)
  (Add-Interval-Constraint 'Cb2 '(:A :B :E) 'Cb1)
  (Add-Interval-Constraint 'Cb2 :Dis 'Oab)
  (Add-Interval-Constraint 'Mabz '(:C :O :Si) 'Cb2)
  (Define-Interval 'Cz2 'stack-demo)
  (Add-Interval-Constraint 'Mabz '(:C :Fi :O) 'Cz2)
  (Define-Interval 'Ca3 'stack-demo)
  (Add-Interval-Constraint 'Ca3 '(:A :B :E) 'Ca1)
  (Add-Interval-Constraint 'Ca3 '(:A :B :E) 'Ca2)
  (Add-Interval-Constraint 'Ca3 :Dis 'Oba)
  (Add-Interval-Constraint 'Mabz :M 'Ca3)
  (Add-Interval-Constraint 'Mabz :O 'Oab)
  (Define-Interval 'Mbcy 'stack-demo)
  (Add-Interval-Constraint 'Mbcy '(:A :Mi) 'I)
  (Add-Interval-Constraint 'Mbcy '(:B :M) 'G)
  (Define-Interval 'Cb4 'stack-demo)
  (Add-Interval-Constraint 'Cb4 '(:A :B :E) 'Cb1)
  (Add-Interval-Constraint 'Cb4 '(:A :B :E) 'Cb2)
  (Add-Interval-Constraint 'Cb4 :Dis 'Oab)
  (Add-Interval-Constraint 'Mbcy :Mi 'Cb4)
  (Define-Interval 'Oby 'stack-demo)
  (Add-Interval-Constraint 'Mbcy :Oi 'Oby)
  (Define-Interval 'Cc4 'stack-demo)
  (Add-Interval-Constraint 'Cc4 :Dis 'Oac)
  (Add-Interval-Constraint 'Cc4 :Dis 'Obc)
  (Add-Interval-Constraint 'Mbcy '(:C :O :Si) 'Cc4)
  (Define-Interval 'Cy4 'stack-demo)
  (Add-Interval-Constraint 'Mbcy '(:C :Fi :O) 'Cy4)
  (Define-Interval 'Cb5 'stack-demo)
  (Add-Interval-Constraint 'Cb5 '(:A :B :E) 'Cb1)
  (Add-Interval-Constraint 'Cb5 '(:A :B :E) 'Cb2)
  (Add-Interval-Constraint 'Cb5 '(:A :B :E) 'Cb4)
  (Add-Interval-Constraint 'Cb5 :Dis 'Oab)
  (Add-Interval-Constraint 'Mbcy :M 'Cb5)
  (Add-Interval-Constraint 'Mbcy :O 'Obc)
  (Show-Interval-Constraints 'Mbca '(Mabc))
  (Show-Interval-Constraints 'Mbcy '(Mabz))
  (Show-Interval-Constraints 'PUac '(PUba))
  (Show-Interval-Constraints 'Ha '(Hb))
  (Show-Interval-Constraints 'PDab '(PDbc))
  (Show-Interval-Constraints 'PUac '(PDbc))
  (Show-Interval-Constraints 'PUba '(PDab))
  (Add-Interval-Constraint 'Oby :E 'Oba)
  (Define-Interval 'Mbca 'stack-demo)
  (Add-Interval-Constraint 'Mbca :E 'Mbcy)
  (Add-Interval-Constraint 'Oaz :E 'Oac)
  (Define-Interval 'Mabc 'stack-demo)
  (Add-Interval-Constraint 'Mabc :E 'Mabz)
  (Define-Interval 'PUac 'stack-demo)
  (Add-Interval-Constraint 'PUac :S 'Mabc)
  (Define-Interval 'Ha 'stack-demo)
  (Add-Interval-Constraint 'Ca1 :Dis 'Ha)
  (Add-Interval-Constraint 'Ca2 :Dis 'Ha)
  (Add-Interval-Constraint 'Ca3 :Dis 'Ha)
  (Add-Interval-Constraint 'Ha :Dis 'Oba)
  (Add-Interval-Constraint 'PUac :M 'Ha)
  (Define-Interval 'PDab 'stack-demo)
  (Add-Interval-Constraint 'Ha :M 'PDab)
  (Add-Interval-Constraint 'PDab :F 'Mabc)
  (Add-Interval-Constraint 'PUac :Mi 'Ca2)
  (Add-Interval-Constraint 'PUac :F 'Oac)
  (Add-Interval-Constraint 'PUac :M 'Ha)
  (Define-Interval 'Cc6 'stack-demo)
  (Add-Interval-Constraint 'Cc6 '(:A :B :E) 'Cc4)
  (Add-Interval-Constraint 'Cc6 :Dis 'Oac)
  (Add-Interval-Constraint 'Cc6 :Dis 'Obc)
  (Add-Interval-Constraint 'PUac :M 'Cc6)
  (Define-Interval 'Cb6 'stack-demo)
  (Add-Interval-Constraint 'Cb6 '(:A :B :E) 'Cb1)
  (Add-Interval-Constraint 'Cb6 '(:A :B :E) 'Cb2)
  (Add-Interval-Constraint 'Cb6 '(:A :B :E) 'Cb4)
  (Add-Interval-Constraint 'Cb6 '(:A :B :E) 'Cb5)
  (Add-Interval-Constraint 'Cb6 :Dis 'Oab)
  (Add-Interval-Constraint 'PDab :Mi 'Cb6)
  (Add-Interval-Constraint 'PDab :Mi 'Ha)
  (Add-Interval-Constraint 'PDab :S 'Oab)
  (Add-Interval-Constraint 'PDab :M 'Ca3)
  (Define-Interval 'PUba 'stack-demo)
  (Add-Interval-Constraint 'PUba :S 'Mbca)
  (Define-Interval 'Hb 'stack-demo)
  (Add-Interval-Constraint 'Cb1 :Dis 'Hb)
  (Add-Interval-Constraint 'Cb2 :Dis 'Hb)
  (Add-Interval-Constraint 'Cb4 :Dis 'Hb)
  (Add-Interval-Constraint 'Cb5 :Dis 'Hb)
  (Add-Interval-Constraint 'Cb6 :Dis 'Hb)
  (Add-Interval-Constraint 'Hb :Dis 'Oab)
  (Add-Interval-Constraint 'PUba :M 'Hb)
  (Define-Interval 'PDbc 'stack-demo)
  (Add-Interval-Constraint 'Hb :M 'PDbc)
  (Add-Interval-Constraint 'PDbc :F 'Mbca)
  (Add-Interval-Constraint 'PUba :Mi 'Cb4)
  (Add-Interval-Constraint 'PUba :F 'Oba)
  (Add-Interval-Constraint 'PUba :M 'Hb)
  (Define-Interval 'Ca7 'stack-demo)
  (Add-Interval-Constraint 'Ca7 '(:A :B :E) 'Ca1)
  (Add-Interval-Constraint 'Ca7 '(:A :B :E) 'Ca2)
  (Add-Interval-Constraint 'Ca7 '(:A :B :E) 'Ca3)
  (Add-Interval-Constraint 'Ca7 :Dis 'Oba)
  (Add-Interval-Constraint 'Ca7 :Dis 'Ha)
  (Add-Interval-Constraint 'PUba :M 'Ca7)
  (Define-Interval 'Cc7 'stack-demo)
  (Add-Interval-Constraint 'Cc7 '(:A :B :E) 'Cc4)
  (Add-Interval-Constraint 'Cc7 '(:A :B :E) 'Cc6)
  (Add-Interval-Constraint 'Cc7 :Dis 'Oac)
  (Add-Interval-Constraint 'Cc7 :Dis 'Obc)
  (Add-Interval-Constraint 'PDbc :Mi 'Cc7)
  (Add-Interval-Constraint 'PDbc :Mi 'Hb)
  (Add-Interval-Constraint 'PDbc :S 'Obc)
  (Add-Interval-Constraint 'PDbc :M 'Cb5)
  (Show-Interval-Constraints 'Mbca '(Mabc))
  (Show-Interval-Constraints 'Mbcy '(Mabz))
  (Show-Interval-Constraints 'PUac '(PUba))
  (Show-Interval-Constraints 'Ha '(Hb))
  (Show-Interval-Constraints 'PDab '(PDbc))
  (Show-Interval-Constraints 'PUac '(PDbc))
  (Show-Interval-Constraints 'PUba '(PDab))
  TL::*TLR-Assert-Count*
)

;;; Xerox Lisp window goodies

(defvar *tl-demo-buttons* nil)

(defvar *tl-demo-intervals-sketchwindow* nil)

(defvar *tl-demo-stack-switch-sketchwindow* nil)

#+xerox
(defun tl-demo-setup (&optional nobuttons? create?)
   (cond (create?
	   (if (il:windowp *tl-demo-intervals-sketchwindow*)
	       (il:closew *tl-demo-intervals-sketchwindow*))
	   (setq *tl-demo-intervals-sketchwindow* nil)))
   (if *tl-demo-intervals-sketchwindow*
       (il:openw *tl-demo-intervals-sketchwindow*)
     (setq *tl-demo-intervals-sketchwindow*
	   (il:sketchw.create *tl-demo-intervals-sketch*
		      '(9.0 25.0 425.0 235.0)
		      (let ((w 450)
			    (h 250))
			(il:createregion (- il:screenwidth w) 500 w h))
		      "6 basic interval relations")))
   (cond (create?
	  (if (il:windowp *tl-demo-stack-switch-sketchwindow*)
	       (il:closew *tl-demo-stack-switch-sketchwindow*))
	   (setq *tl-demo-stack-switch-sketchwindow* nil)))
   (if *tl-demo-stack-switch-sketchwindow*
       (il:openw *tl-demo-stack-switch-sketchwindow*)
     (setq *tl-demo-stack-switch-sketchwindow*
	   (il:sketchw.create *tl-demo-stack-switch-sketch*
		      '(46.0 -18.0 545.0 279.0)
		      (let ((w 550)
			    (h 300))
			(il:createregion (- il:screenwidth w) 500 w h))
		      "Overlapping actions:  switching two blocks")))
   (cond ((or create? nobuttons?)
	  (mapc #'il:delete-button *tl-demo-buttons*)
	  (setq *tl-demo-buttons* nil)))
   (unless (fboundp #'il:create-button) (setq nobuttons? t))
   (setq nobuttons? t)
   (cond (nobuttons?
	   (il:windowprop (il:shrinkw *tl-demo-intervals-sketchwindow*
				      nil '(500 . 500))
			  'il:title "Intervals")
	   (il:windowprop (il:shrinkw *tl-demo-stack-switch-sketchwindow*
				      nil '(575 . 500))
			  'il:title "Block Switch"))
	 (t (il:closew *tl-demo-intervals-sketchwindow*)
	    (il:closew *tl-demo-stack-switch-sketchwindow*)
	    (if *tl-demo-buttons*
		(mapc #'il:redisplay-button *tl-demo-buttons*)
	      (setq *tl-demo-buttons*
		    (list (il:create-button
			    '(if (il:openwp *tl-demo-intervals-sketchwindow*)
				 (il:closew *tl-demo-intervals-sketchwindow*)
			       (il:openw *tl-demo-Intervals-SketchWindow*))
			    "Intervals"
			    '(249 . 113))
			  (il:create-button
			    '(if (il:openwp *tl-demo-stack-switch-sketchwindow*)
				 (il:closew *tl-demo-stack-switch-sketchwindow*)
			       (il:openw *tl-demo-stack-switch-sketchwindow*))
			    "Block Switch"
			    '(249 . 64))
			  (il:create-button
			    '(tl::tl-graph-refs
			       "TimeLogic Reference Hierarchy")
			    "Graph Refs"
			    '(249 . 15))
			  (il:create-button
			    "(tl-demo)"
			    "TimeLogic Demo"
			    '(366 . 15)))))))
   (timelogic-prop :auto-reference :on)
)

#+xerox (tl-demo-setup)
